/*
 * Decompiled with CFR 0.152.
 */
package minicmds.diff;

import java.util.Arrays;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;

public class Argument {
    private static final String HELP_CHAR = "h";
    private static final String HELP_LONG = "help";
    private CommandLine cmd = null;
    private CommandLineParser parser = new PosixParser();
    private Options options = new Options();
    private String before = null;
    private String after = null;

    public Argument() {
        this.options.addOption(new Option(HELP_CHAR, HELP_LONG, false, "\u4f7f\u7528\u65b9\u6cd5\u3092\u8868\u793a\u3057\u307e\u3059\u3002"));
    }

    public void printUsage() {
        HelpFormatter help = new HelpFormatter();
        help.printHelp("minicmds.diff.Diff [\u30aa\u30d7\u30b7\u30e7\u30f3] \u5909\u66f4\u524d\u30d1\u30b9 \u5909\u66f4\u5f8c\u30d1\u30b9", "\u30aa\u30d7\u30b7\u30e7\u30f3\u5f15\u6570", this.options, "", false);
        System.out.println("\u30d1\u30b9  \u30d5\u30a1\u30a4\u30eb/\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u304c\u6307\u5b9a\u53ef\u80fd\u3002\u5909\u66f4\u524d/\u5f8c\u304c\u30d5\u30a1\u30a4\u30eb\u306e\u5834\u5408\u30012\u3064\u306e\u30d5\u30a1\u30a4\u30eb\u3092\u6bd4\u8f03\u3057\u307e\u3059\u3002\u5909\u66f4\u524d/\u5f8c\u304c\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u306e\u5834\u5408\u3001\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u5185\u3092\u518d\u5e30\u7684\u306b\u6bd4\u8f03\u3057\u307e\u3059\u3002\u30d5\u30a1\u30a4\u30eb\u3068\u3057\u3066\u6307\u5b9a\u3067\u304d\u308b\u306e\u306f\u30c6\u30ad\u30b9\u30c8/Excel\u30d5\u30a1\u30a4\u30eb\u3067\u3059\u3002");
    }

    public void parse(String[] strings) {
        if (strings.length == 0) {
            strings = new String[]{"--help"};
        }
        try {
            this.cmd = this.parser.parse(this.options, strings);
        }
        catch (ParseException e) {
            throw new RuntimeException("\u5f15\u6570\u30a8\u30e9\u30fc\uff1a" + Arrays.toString(strings), e);
        }
        if (this.isHelpFlag()) {
            return;
        }
        for (String arg : this.cmd.getArgs()) {
            if (this.before == null) {
                this.before = arg;
                continue;
            }
            if (this.after == null) {
                this.after = arg;
                continue;
            }
            throw new RuntimeException("\u5f15\u6570\u30a8\u30e9\u30fc\uff1a" + arg);
        }
        if (this.before == null || this.after == null) {
            throw new RuntimeException("\u5f15\u6570\u30a8\u30e9\u30fc\uff1a\u5fc5\u9808\u9805\u76ee\u306a\u3057");
        }
    }

    public boolean isHelpFlag() {
        if (this.cmd.hasOption(HELP_CHAR)) {
            return true;
        }
        return this.cmd.getArgList().size() == 0;
    }

    public String getBefore() {
        return this.before;
    }

    public String getAfter() {
        return this.after;
    }
}

