class QSO
  attr_writer :callsign, :daytime, :qso_freq, :qso_mode, :rst_sent, :nr_sent, :rst_rcvd, :nr_rcvd
  attr_reader :callsign, :daytime, :qso_freq, :qso_mode, :rst_sent, :nr_sent, :rst_rcvd, :nr_rcvd

#  @@my_callsign = "JL3OXR"
  if ENV['QSO_MY_CALLSIGN']
    @@my_callsign=ENV['QSO_MY_CALLSIGN']
  else
    @@my_callsign="NOCALL"
  end

  def initialize
    @callsign = ""
    @daytime = Time.at(0)
    @qso_freq = 0.0
    @qso_mode = ""
    @rst_sent = ""
    @nr_sent = ""
    @rst_rcvd = ""
    @nr_rcvd = ""
  end

# Define null methods
  def write_header
  end
  def write_footer
  end
  def read_header
  end
  def read_footer
  end

  def freq_range
    case @qso_freq
      when 1.8 .. 2.0 then 1.8 # in JA, 1.810 - 1.825 and 1.9075 - 1.9125
      when 3.5 .. 4.0 then 3.5
                      # in JA, 3.50 - 3.575, 3.747 - 3.754 and 3.791 - 3.805
      when 7.0 .. 7.3 then 7.0  # in JA, 7.0 - 7.1
      when 10.1 .. 10.15 then 10.0
      when 14.0 .. 14.35 then 14.0
      when 18.068 .. 18.168 then 18.0
      when 21.0 .. 21.45  then 21.0
      when 24.89 .. 24.99 then 24.0
      when 28.0 .. 29.7 then 28.0
      when 50.0 .. 54.0 then 50.0
      when 144.0 .. 148.0 then 144.0    # in JA, 144.0 - 146.0
      when 222.0 .. 225.0 then 220.0    # in JA, not assigned.
      when 420.0 .. 450.0 then 430.0    # in JA, 430.0 - 440.0
      when 902.0 .. 928.0 then 900.0    # in JA, not assigned.
      when 1240.0 .. 1300.0 then 1200.0 # in JA, 1260.0 - 1300.0
      when 2300.0 .. 2450.0 then 2400.0 # in JA, 2400.0 - 2450.0
      when 3300.0 .. 3500.0 then 3300.0 # in JA, not assigned.
      when 5650.0 .. 5925.0 then 5600.0 # in JA, 5650.0 - 5850.0
      when 10000.0 .. 10500.0 then 10000.0
                            # in JA, 10000.0 - 10250.0 and 10450.0 - 10500.0
      when 24000.0 .. 24250.0 then 24000.0 # in JA, 24000.0 - 24050.0
      when 47000.0 .. 50000.0 then 47000.0 # in JA, 47000.0 - 47200.0
      when 71000.0 .. 76000.0 then 75000.0 # in JA, 75500.0 - 76000.0
      when 120000.0 .. 120500.0 then 120000.0 # in JA, not assigned.
      when 142000.0 .. 144000.0 then 142000.0 # in JA, 142000.0 - 144000.0
      when 165000.0 .. 170000.0 then 165000.0 # Is this Reg. 2 only ?? 
      when 240000.0 .. 250000.0 then 240000.0 # in JA, 248000.0 - 250000.0
      when 300000.0 .. 300000.1 then 300000.0
# This band is supported in Cabrillo format, but no info is available.
# Could someone let me know?
      else raise "Freq. range?? #{@qso_freq}"
    end
  end
###################################################
# A simple example is given below.
#
# require "qso"
#
# zlog = ZlogDos.new
# adif = Adif.new
#
# zlog.read_header
# adif.write_header
# until $<.eof?
#   zlog.read_a_record
#
#   QSO::convert(zlog, adif)
#   adif.write
#  end
##################################################
#
#  def read
#    read_header
#    read_a_record until eof?
#    read_footer
#  end returns an array object.
#
#  def read_a_record
#    readline
#    parse
#  end returns single object?
#

  def QSO.convert(src, dest)
    dest.callsign = src.callsign
     dest.daytime = src.daytime
    dest.qso_freq = src.qso_freq
    dest.qso_mode = src.qso_mode
    dest.rst_sent = src.rst_sent
     dest.nr_sent = src.nr_sent
    dest.rst_rcvd = src.rst_rcvd
     dest.nr_rcvd = src.nr_rcvd
  end
end

class Adif < QSO
  def initialize
    super
    @adif_field = Hash.new
    @adif_opt_type = Hash.new
    @band = {
      '160m' => 1.8,      '80m' => 3.5,      '40m' => 7.0,
      '30m' => 10.0,      '20m' => 14.0,      '17m' => 18.0,
      '15m' => 21.0,      '12m' => 24.0,      '10m' => 28.0,
      '6m' => 50.0,      '2m' => 144.0,      '1.25m' => 220.0,
      '70cm' => 430.0,      '35cm' => 900.0,      '23cm' => 1200.0,
      '13cm' => 2400.0,      '9cm' => 3300.0,      '6cm' => 5600.0,
      '3cm' => 10000.0,      '1.25cm' => 24000.0,      '6mm' => 47000.0,
      '4mm' => 75000.0,      '2.5mm' => 120000.0,      '2mm' => 142000.0,
      '1mm' => 165000.0
    }
  end ### End method #initialize

  def write
    print "<call:#{@callsign.length}>#{@callsign}"
    print "<qso_date:8>#{@daytime.utc.strftime("%Y%m%d")}"
    print "<time_on:6>#{@daytime.utc.strftime("%H%M%S")}"
    temp = @band.index(freq_range)
    if temp == nil
      raise "Unsupported band is set."
    end
    print "<band:#{temp.length}>#{temp}"
    print "<mode:#{@qso_mode.length}>#{@qso_mode}"
    print "<rst_sent:#{@rst_sent.length}>#{@rst_sent}"
    print "<rst_rcvd:#{@rst_rcvd.length}>#{@rst_rcvd}"
    print "<eor>\n"
  end ### End method #write

  def parse
    record = $<.readline("<eor>")
    record.delete!("\n")

    record.gsub!(/</, "\n").each do |each_field|
      each_field.chop!
      next if each_field.empty?
      break if each_field == "eor"
      field_tag, field_data = each_field.split(">")
      field_name, field_size, field_type = field_tag.split(":")
      unless field_type.nil?
        @adif_opt_type[field_name.downcase] = field_type.downcase
      end
      @adif_field[field_name.downcase] = field_data[0, field_size.to_i]
    end ### End do |each_field|
  end ### End method parse

  def read_a_record
    parse
    @callsign = @adif_field['call'].upcase
    temp_date = @adif_field['qso_date']
    temp_time = @adif_field['time_on']
    @daytime = Time.utc(temp_date[0..3], temp_date[4..5], temp_date[6..7], \
      temp_time[0..1], temp_time[2..3])
    @daytime += temp_time[4..5].to_i if temp_time.length == 6
    @qso_freq = @band["#{@adif_field['band'].downcase}"]
    @qso_mode = @adif_field['mode'].upcase
    @rst_sent = @adif_field['rst_sent']
    @rst_rcvd = @adif_field['rst_rcvd']
    @nr_sent = @adif_field['stx']
    @nr_rcvd = @adif_field['rtx']
  end ### End method #read_a_record
end ### End class Adif

class Cabrillo < QSO
  def initialize
    super
    @band = {
      '50' => 50.0,
      '144' => 144.0,
      '222' => 220.0,
      '432' => 430.0,
      '902' => 900.0,
      '1.2' => 1200.0,
      '2.3' => 2400.0,
      '3.4' => 3300.0,
      '5.7' => 5600.0,
      '10' => 10000.0,
      '24' => 24000.0,
      '47' => 47000.0,
      '75' => 75000.0,
      '119' => 120000.0,
      '142' => 142000.0,
      '241' => 240000.0, 
      '300' => 300000.0
# LIGHT is not supported at this stage.
    }
  end
  def write
    print "QSO: "
    if @qso_freq < 30.0
      printf("%5d ", @qso_freq * 1000)
    else
      temp = @band.index(freq_range)
      raise "Unsupported band is set." if temp == nil
      printf("%5s ", temp)
    end

    if @qso_mode == ( "CW" || "FM" )
      printf("%2s ", @qso_mode)
    elsif @qso_mode == "RTTY"
      print "RY "
    else
      print "PH "  # Even though not really adequate....
    end
    printf("%10s ", @daytime.utc.strftime("%Y-%m-%d"))
    printf("%4s ", @daytime.utc.strftime("%H%M"))
    printf("%-13s ", @@my_callsign)
    printf("%-3s ", @rst_sent)
    printf("%6s ", @nr_sent)
    printf("%-13s ", @callsign)
    printf("%-3s ", @rst_rcvd)
    printf("%6s ", @nr_rcvd)
    printf("1\n")
  end
end

class ZlogDos < QSO
  def initialize
    super
    @band = {
      '1.9' => 1.8,
      '3.5' => 3.5,
      '7' => 7.0,
      '14' => 14.0,
      '21' => 21.0,
      '28' => 28.0,
      '50' => 50.0,
      '144' => 144.0,
      '430' => 430.0,
      '1200' => 1200.0,
      '2400' => 2400.0,
      '5600' => 5600.0,
      '10G' => 10000.0
    }

    if ENV['QSO_ZLOG_YEAR']
      if ENV['QSO_ZLOG_YEAR'] =~ /^[0-9]{4}$/
        @zlog_year = ENV['QSO_ZLOG_YEAR']
      else
        raise "Invalid QSO_ZLOG_YEAR: #{ENV['QSO_ZLOG_YEAR']}"
      end
    else
      @zlog_year = Time.now.strftime("%Y")
    end
  end
  def write_header
    print "mon day time  callsign      sent\
         rcvd      multi   MHz mode pts memo\r\n"
  end
  def write
    jst_time = @daytime.utc + 9 * 60 * 60
# Time zone is fixed to JST, since this format is used only inside of JA.
    printf(" %2d ", jst_time.mon)
    printf(" %2d ", jst_time.day)
    printf("%02d%02d ", jst_time.hour, jst_time.min)
    printf("%-10s", @callsign)
    printf(" %3s", @rst_sent)
    printf("%-8s ", @nr_sent)
    printf(" %3s", @rst_rcvd)
    printf("%-8s ", @nr_rcvd)
    printf("        ") # if multi?
# The column for MULTI is doing nothing. This might be supported.
# But think. Such stuff should be done by logging tools, shouldn't it?
    temp = @band.index(freq_range)
    if temp == nil
      raise "Unsupported band is set."
    end
    printf(" %4s ", temp ) 
    printf(" %-3s ", @qso_mode)
    printf("1  \r\n")
  end
  def read_header
    $<.readline
  end
  def read_a_record
    record = $<.readline.chomp

    jst_time = Time.utc(@zlog_year, record[1..2].to_i, record[5..6].to_i,\
      record[8..9].to_i, record[10..11].to_i)
    @daytime = jst_time - 9 * 60 * 60
    @callsign = record[13..22].strip
    @rst_sent = record[24..26].strip
    @nr_sent = record[27..34].strip
    @rst_rcvd = record[37..39].strip
    @nr_rcvd = record[40..47].strip
    temp = record[58..61].strip
    @qso_freq = @band[temp]
    @qso_mode = record[64..66].strip
  end
end

class ZlogWin < QSO
  def initialize
    super
    @band = {
      '1.9' => 1.8,
      '3.5' => 3.5,
      '7' => 7.0,
      '10' => 10.0,
      '14' => 14.0,
      '18' => 18.0,
      '21' => 21.0,
      '24' => 24.0,
      '28' => 28.0,
      '50' => 50.0,
      '144' => 144.0,
      '430' => 430.0,
      '1200' => 1200.0,
      '2400' => 2400.0,
      '5600' => 5600.0,
      '10G' => 10000.0
    }

  end
  def write_header
    print "zLog for Windows \r\n"
  end
  def write
    jst_time = @daytime.utc + 9 * 60 * 60
# Time zone is fixed to JST, since this format is used only inside of JA.
    printf("%04d/%02d/%02d ", jst_time.year, jst_time.mon, jst_time.day)
    printf("%02d:%02d ", jst_time.hour, jst_time.min)
    printf("%-12s ", @callsign)
    printf("%-3s ", @rst_sent)
    printf("%-7s ", @nr_sent)
    printf("%-3s ", @rst_rcvd)
    printf("%-7s ", @nr_rcvd)
    printf("-     -     ") # if multi?
# The column for MULTI is doing nothing. This might be supported.
# But think. Such stuff should be done by logging tools, shouldn't it?
    temp = @band.index(freq_range)
    if temp == nil
      raise "Unsupported band is set."
    end
    printf("%-4s ", temp )
    unless @qso_mode == ( "SSB" || "CW" || "AM" || "FM" || "RTTY" )
      @qso_mode = "Other"
    end
    printf("%-5s", @qso_mode)
    printf("1  \r\n")
  end
  def read_header
    $<.readline
  end
  def read_a_record
    record = $<.readline.chomp

    jst_time = Time.utc(record[1..4].to_i, record[6..7].to_i,\
      record[9..10].to_i, record[12..13].to_i, record[15..16].to_i)
    @daytime = jst_time - 9 * 60 * 60
    @callsign = record[18..29].strip
    @rst_sent = record[31..33].strip
    @nr_sent = record[35..41].strip
    @rst_rcvd = record[43..45].strip
    @nr_rcvd = record[47..53].strip
    temp = record[67..70].strip
    @qso_freq = @band[temp]
    @qso_mode = record[72..76].strip
    @qso_mode = "PSK31" if @qso_mode == "Other" # Cast to any.
  end
end

