// -*- C++ -*-
/*!
 * @file TkPeriodicExecutionContext.cpp
 * @brief TkPeriodicExecutionContext class
 * @date $Date$
 * @author Noriaki Ando <n-ando@aist.go.jp>
 *
 * Copyright (C) 2007
 *     Task-intelligence Research Group,
 *     Intelligent Systems Research Institute,
 *     National Institute of
 *         Advanced Industrial Science and Technology (AIST), Japan
 *     All rights reserved.
 *
 * $Id$
 *
 */

/*
 * $Log$
 */

#include "TkPeriodicExecutionContext.h"
#include <rtm/ECFactory.h>
#include <linux/art_task.h>

#include <iostream>

namespace RTC
{
  TkPeriodicExecutionContext::TkPeriodicExecutionContext()
    : PeriodicExecutionContext()
  {
  }

  TkPeriodicExecutionContext::~TkPeriodicExecutionContext()
  {
  }


  int TkPeriodicExecutionContext::svc(void)
  {
#ifdef DEBUG_T_KERNEL_RATE
    printf("T_KERNEL %s:%d\n", __FILE__, __LINE__);
#endif
    coil::TimeValue past;
    coil::TimeValue now;
    coil::TimeValue period;
    
    RTC_TRACE(("svc()"));
    do 
      {
        m_worker.mutex_.lock();
        
        now = coil::clock_gettime();
        
#ifdef DEBUG_T_KERNEL_RATE
        printf("T_KERNEL %s:%d\n", __FILE__, __LINE__);
        printf("T_KERNEL rate now-past sec:%d  usec:%d\n",
            now.sec() - past.sec(), now.usec() - past.usec());
#endif
        past = now ;
        
        while (!m_worker.running_)
          {
            m_worker.cond_.wait();
          }
        if (m_worker.running_)
          {
            std::for_each(m_comps.begin(), m_comps.end(), invoke_worker());
         }
        
        now = coil::clock_gettime();
        
        period = coil::TimeValue( m_period.sec(), m_period.usec());
        period = period + past;
        period = period - now;
        
        m_worker.mutex_.unlock();
        
        if(!m_nowait && period.sec() >= 0 && period.usec() >= 0) { coil::sleep( period ); }
        
      } while (m_svc);

    return 0;
  }
};


extern "C"
{
  void TkPeriodicExecutionContextInit(RTC::Manager* manager)
  {
#ifdef DEBUG_T_KERNEL_RATE
    printf("T_KERNEL %s:%d\n", __FILE__, __LINE__);
#endif
    RTC::Manager::instance().registerECFactory("TkPeriodicExecutionContext",
    			       RTC::ECCreate<RTC::TkPeriodicExecutionContext>,
    			       RTC::ECDelete<RTC::TkPeriodicExecutionContext>);
    
  }
};
