// -*- C++ -*-
/*!
 * @file  NonCopyable.h
 * @brief Non Copyable mixin class
 * @date  $Date$
 * @author Noriaki Ando <n-ando@aist.go.jp>
 *
 * Copyright (C) 2008
 *     Noriaki Ando
 *     Task-intelligence Research Group,
 *     Intelligent Systems Research Institute,
 *     National Institute of
 *         Advanced Industrial Science and Technology (AIST), Japan
 *     All rights reserved.
 *
 * $Id$
 *
 */

namespace coil
{
  /*!
   * @if jp
   * @class NonCopyable
   * @brief ԡػߥߥå
   * 
   * оݥ饹Υ֥ȤΥԡػߤ롣ԡػߤ
   * ǤϡNonCopyableprivateѾ뤳Ȥǥ֥ȤΥԡ
   * ߤ뤳ȤǤ롣
   *
   * -:
   * class CopyProhibitedClass : private NonCopyable {};
   *
   * @else
   *
   * @class NonCopyable
   * @brief Non-copyable Mixin
   *
   * This mix-in class prevents objects of a class from being
   * copy-constructed or assigned to each other. User can prohibit the
   * class copying by inheriting from NonCopyable class as a private
   * base class.
   *
   * -example:
   * class CopyProhibitedClass : private NonCopyable {};
   *
   * @endif
   */
  class NonCopyable
  {
  protected:
    NonCopyable() {}
    ~NonCopyable() {}
  private:
    NonCopyable(const NonCopyable&);
    NonCopyable& operator=(const NonCopyable&);
  };

  /*!
   * @if jp
   * @class NonCopyableCRTP
   * @brief ԡػߥߥå(CRTP)
   * 
   * оݥ饹Υ֥ȤΥԡػߤ롣ԡػߤ
   * ǤϡNonCopyableprivateѾ뤳Ȥǥ֥ȤΥԡ
   * ߤ뤳ȤǤ롣CRTP (Curiously Recursive Template
   * Pattern) Ǥϡδ쥯饹ФŬ (Empty Base
   * Optimization) Ԥ碌Ѥ롣
   *
   * -:
   * struct A : NonCopyableCRTP<A> {};
   * struct B : NonCopyableCRTP<B> {};
   * struct C: A, B {};
   *
   * @else
   *
   * @class NonCopyable
   * @brief Non-copyable Mixin
   *
   * This mix-in class prevents objects of a class from being
   * copy-constructed or assigned to each other. User can prohibit the
   * class copying by inheriting from NonCopyable class as a private
   * base class.The CRTP (Curiously Recursive Template Pattern)
   * version would be used for empty base optimization for
   * multipe-inherited.
   *
   * -example:
   * class CopyProhibitedClass : private NonCopyable {};
   *
   * @endif
   */
  template <class T>
  class NonCopyableCRTP
  {
  protected:
    NonCopyable () {}
    ~NonCopyable () {}
  private: 
    NonCopyable (const NonCopyable &);
    T & operator = (const T &);
  };
};
