// -*- C++ -*-
/*!
 * @file  MyServiceConsumer.cpp * @brief MyService Consumer Sample component * $Date$ 
 *
 * $Id$ 
 */
#include "MyServiceConsumer.h"
#include <rtm/CORBA_SeqUtil.h>
#include <vector>
#include <stdlib.h>
#include <coil/Async.h>
#include <functional>

#ifdef DEBUG
#include <util/tmonitor.h>
#endif

// Module specification
// <rtc-template block="module_spec">
static const char* myserviceconsumer_spec[] =
  {
    "implementation_id", "MyServiceConsumer",
    "type_name",         "MyServiceConsumer",
    "description",       "MyService Consumer Sample component",
    "version",           "0.1",
    "vendor",            "AIST",
    "category",          "Generic",
#ifdef __T_KERNEL__
    "activity_type",     "DataFlowComponent",
#else
    "activity_type",     "SPORADIC",
    "kind",              "MyServiceConsumer",
#endif
    "max_instance",      "10",
    "language",          "C++",
    "lang_type",         "compile",
    // Configuration variables
    ""
  };
// </rtc-template>

MyServiceConsumer::MyServiceConsumer(RTC::Manager* manager)
    // <rtc-template block="initializer">
  : RTC::DataFlowComponentBase(manager),
    m_MyServicePort("MyService"),

    // </rtc-template>
    async_set_value(0), async_echo(0)
{
}

MyServiceConsumer::~MyServiceConsumer()
{
}


RTC::ReturnCode_t MyServiceConsumer::onInitialize()
{
  // Registration: InPort/OutPort/Service
  // <rtc-template block="registration">
  // Set InPort buffers

  // Set OutPort buffer

  // Set service provider to Ports

  // Set service consumers to Ports
#ifdef DEBUG
//DEL tm_monitor();
#endif 
  m_MyServicePort.registerConsumer("myservice0", "MyService", m_myservice0);

//DEL printf("%s:%d m_myservice0:%x\n", __FILE__, __LINE__, m_myservice0);
  // Set CORBA Service Ports
  addPort(m_MyServicePort);

  // </rtc-template>

  // <rtc-template block="bind_config">
  // Bind variables and configuration variable

  // </rtc-template>
  return RTC::RTC_OK;
}


/*
RTC::ReturnCode_t MyServiceConsumer::onFinalize()
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t MyServiceConsumer::onStartup(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t MyServiceConsumer::onShutdown(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t MyServiceConsumer::onActivated(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t MyServiceConsumer::onDeactivated(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/

RTC::ReturnCode_t MyServiceConsumer::onExecute(RTC::UniqueId ec_id)
{
  try
    {
      std::cout << std::endl;
      std::cout << "Command list: " << std::endl;
      std::cout << " echo [msg]       : echo message." << std::endl;
      std::cout << " set_value [value]: set value." << std::endl;
      std::cout << " get_value        : get current value." << std::endl;
      std::cout << " get_echo_history : get input messsage history." << std::endl;
      std::cout << " get_value_history: get input value history." << std::endl;
      std::cout << "> ";
      std::string args;
      std::string::size_type pos;
      std::vector<std::string> argv;
      std::getline(std::cin, args);
      
      pos = args.find_first_of(" ");
      if (pos != std::string::npos)
	{
//printf("%s:%d\n", __FILE__, __LINE__);      
	  argv.push_back(args.substr(0, pos));
//printf("%s:%d\n", __FILE__, __LINE__);      
	  argv.push_back(args.substr(++pos));
//printf("%s:%d\n", __FILE__, __LINE__);      
	}
      else
	{
//printf("%s:%d\n", __FILE__, __LINE__);      
	  argv.push_back(args);
//printf("%s:%d\n", __FILE__, __LINE__);      
	}
      
//printf("%s:%d\n", __FILE__, __LINE__);      
      if (async_echo != 0 && async_echo->finished())
        {
//printf("%s:%d\n", __FILE__, __LINE__);      
          std::cout << "echo() finished: " <<  m_result << std::endl;
//printf("%s:%d\n", __FILE__, __LINE__);      
          delete async_echo;
//printf("%s:%d\n", __FILE__, __LINE__);      
          async_echo = 0;
//printf("%s:%d\n", __FILE__, __LINE__);      
        }
//printf("%s:%d\n", __FILE__, __LINE__);      
      
      if (argv[0] == "echo" && argv.size() > 1)
	{
//printf("%s:%d\n", __FILE__, __LINE__);      
          if (async_echo == 0)
            {
              // char* retmsg;
              // retmsg = m_myservice0->echo(argv[1].c_str());
//printf("%s:%d\n", __FILE__, __LINE__);     
#ifdef DEBUG
//DEL tm_monitor();
#endif 
              async_echo = 
                coil::AsyncInvoker(&m_myservice0,
                                   echo_functor(argv[1], m_result));
//printf("%s:%d\n", __FILE__, __LINE__);      
              async_echo->invoke();
//printf("%s:%d\n", __FILE__, __LINE__);      
              // std::cout << "echo return: " << retmsg << std::endl;
            }
          else
            {
//printf("%s:%d\n", __FILE__, __LINE__);      
              std::cout << "set_value() still invoking" << std::endl;
//printf("%s:%d\n", __FILE__, __LINE__);      
            }
//printf("%s:%d\n", __FILE__, __LINE__);      
	  return RTC::RTC_OK;
	}
//printf("%s:%d\n", __FILE__, __LINE__);      
      
      if (argv[0] == "set_value" && argv.size() > 1)
	{
//printf("%s:%d\n", __FILE__, __LINE__);      
          CORBA::Float val(atof(argv[1].c_str()));
//printf("%s:%d\n", __FILE__, __LINE__);      
          coil::AsyncInvoker(&m_myservice0, set_value_functor(val),
                             true)->invoke();
//printf("%s:%d\n", __FILE__, __LINE__);      
          std::cout << "Set remote value: " << val << std::endl;
//printf("%s:%d\n", __FILE__, __LINE__);      

          return RTC::RTC_OK;
	}
//printf("%s:%d\n", __FILE__, __LINE__);      
      
      if (argv[0] == "get_value")
	{
//printf("%s:%d\n", __FILE__, __LINE__);      
	  std::cout << "Current remote value: "
		    << m_myservice0->get_value() << std::endl;
//printf("%s:%d\n", __FILE__, __LINE__);      
	  return RTC::RTC_OK;
	}
//printf("%s:%d\n", __FILE__, __LINE__);      
      
      if (argv[0] == "get_echo_history")
	{
//printf("%s:%d\n", __FILE__, __LINE__);      
	  CORBA_SeqUtil::for_each(*(m_myservice0->get_echo_history()),
				  seq_print<const char*>());
//printf("%s:%d\n", __FILE__, __LINE__);      
	  return RTC::RTC_OK;
	}
//printf("%s:%d\n", __FILE__, __LINE__);      
      
      if (argv[0] == "get_value_history")
	{
//printf("%s:%d\n", __FILE__, __LINE__);      
	  CORBA_SeqUtil::for_each(*(m_myservice0->get_value_history()),
				  seq_print<CORBA::Float>());
//printf("%s:%d\n", __FILE__, __LINE__);      
	  return RTC::RTC_OK;
	}
      
      std::cout << "Invalid command or argument(s)." << std::endl;
    }
  catch (...)
    {
//printf("%s:%d\n", __FILE__, __LINE__);      
      std::cout << "No service connected." << std::endl;
//printf("%s:%d\n", __FILE__, __LINE__);      
    }
  return RTC::RTC_OK;
}

/*
RTC::ReturnCode_t MyServiceConsumer::onAborting(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t MyServiceConsumer::onError(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t MyServiceConsumer::onReset(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t MyServiceConsumer::onStateUpdate(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t MyServiceConsumer::onRateChanged(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/


extern "C"
{
 
  void MyServiceConsumerInit(RTC::Manager* manager)
  {
    coil::Properties profile(myserviceconsumer_spec);
    manager->registerFactory(profile,
                             RTC::Create<MyServiceConsumer>,
                             RTC::Delete<MyServiceConsumer>);
  }
  
};



