// -*- C++ -*-
/*!
 * @file  RangerGeometryOut.cpp * @brief OutPort example component * $Date$ 
 *
 * $Id$ 
 */
#include "RangerGeometryOut.h"

// Module specification
// <rtc-template block="module_spec">
static const char* rangergeometryout_spec[] =
  {
    "implementation_id", "RangerGeometryOut",
    "type_name",         "RangerGeometryOut",
    "description",       "OutPort example component",
    "version",           "1.0",
    "vendor",            "NEC Soft Ltd",
    "category",          "example",
    "activity_type",     "SPORADIC",
    "kind",              "DataFlowComponent",
    "max_instance",      "1",
    "language",          "C++",
    "lang_type",         "compile",
    // Configuration variables
    ""
  };
// </rtc-template>

RangerGeometryOut::RangerGeometryOut(RTC::Manager* manager)
    // <rtc-template block="initializer">
  : RTC::DataFlowComponentBase(manager),
    m_RGdataOut("RGdata", m_RGdata)

    // </rtc-template>
{
}

RangerGeometryOut::~RangerGeometryOut()
{
}


RTC::ReturnCode_t RangerGeometryOut::onInitialize()
{
  // Registration: InPort/OutPort/Service
  // <rtc-template block="registration">
  // Set InPort buffers

  // Set OutPort buffer
  addOutPort("RGdata", m_RGdataOut);

  // Set service provider to Ports

  // Set service consumers to Ports

  // Set CORBA Service Ports

  // </rtc-template>

  // <rtc-template block="bind_config">
  // Bind variables and configuration variable

  // </rtc-template>
  return RTC::RTC_OK;
}


/*
RTC::ReturnCode_t RangerGeometryOut::onFinalize()
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t RangerGeometryOut::onStartup(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t RangerGeometryOut::onShutdown(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t RangerGeometryOut::onActivated(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t RangerGeometryOut::onDeactivated(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/

RTC::ReturnCode_t RangerGeometryOut::onExecute(RTC::UniqueId ec_id)
{
  int i, maxsize;

  m_RGdata.geometry.pose.position.x = 1;
  m_RGdata.geometry.pose.position.y = 2;
  m_RGdata.geometry.pose.position.z = 3;

  m_RGdata.geometry.pose.orientation.r = 4;
  m_RGdata.geometry.pose.orientation.p = 5;
  m_RGdata.geometry.pose.orientation.y = 6;

  m_RGdata.geometry.size.l = 7;
  m_RGdata.geometry.size.w = 8;
  m_RGdata.geometry.size.h = 9;

  m_RGdata.elementGeometries.length(2);
//  m_RGdata.elementGeometries.length(1);
  for(i = 0; i < 2; i++)
  {
    m_RGdata.elementGeometries[i].pose.position.x = ( (i+1) * 10 ) + 1;
    m_RGdata.elementGeometries[i].pose.position.y = ( (i+1) * 10 ) + 2;
    m_RGdata.elementGeometries[i].pose.position.z = ( (i+1) * 10 ) + 3;

    m_RGdata.elementGeometries[i].pose.orientation.r = ( (i+1) * 10 ) + 4;
    m_RGdata.elementGeometries[i].pose.orientation.p = ( (i+1) * 10 ) + 5;
    m_RGdata.elementGeometries[i].pose.orientation.y = ( (i+1) * 10 ) + 6;

    m_RGdata.elementGeometries[i].size.l = ( (i+1) * 10 ) + 7;
    m_RGdata.elementGeometries[i].size.w = ( (i+1) * 10 ) + 8;
    m_RGdata.elementGeometries[i].size.h = ( (i+1) * 10 ) + 9;
  }

  std::cout << "RangerGeometry write" << std::endl;
  std::cout << "  Geometry3D:" << std::endl;
  std::cout << "    Pose3D:" << std::endl;
  std::cout << "      Point3D:" << std::endl;
  std::cout << "        x:" << m_RGdata.geometry.pose.position.x << std::endl;
  std::cout << "        y:" << m_RGdata.geometry.pose.position.y << std::endl;
  std::cout << "        z:" << m_RGdata.geometry.pose.position.z << std::endl;
  std::cout << "      Orientation3D:" << std::endl;
  std::cout << "        r:" << m_RGdata.geometry.pose.orientation.r << std::endl;
  std::cout << "        p:" << m_RGdata.geometry.pose.orientation.p << std::endl;
  std::cout << "        y:" << m_RGdata.geometry.pose.orientation.y << std::endl;
  std::cout << "    Size3D:" << std::endl;
  std::cout << "        l:" << m_RGdata.geometry.size.l << std::endl;
  std::cout << "        w:" << m_RGdata.geometry.size.w << std::endl;
  std::cout << "        h:" << m_RGdata.geometry.size.h << std::endl;
  maxsize = m_RGdata.elementGeometries.length();
  std::cout << "  ElementGeometryList:" << std::endl;
  for(i = 0; i < maxsize; i++)
  {
    std::cout << "    " << i << std::endl;
    std::cout << "      Pose3D:" << std::endl;
    std::cout << "        Point3D:" << std::endl;
    std::cout << "          x:" << m_RGdata.elementGeometries[i].pose.position.x << std::endl;
    std::cout << "          y:" << m_RGdata.elementGeometries[i].pose.position.y << std::endl;
    std::cout << "          z:" << m_RGdata.elementGeometries[i].pose.position.z << std::endl;
    std::cout << "        Orientation3D:" << std::endl;
    std::cout << "          r:" << m_RGdata.elementGeometries[i].pose.orientation.r << std::endl;
    std::cout << "          p:" << m_RGdata.elementGeometries[i].pose.orientation.p << std::endl;
    std::cout << "          y:" << m_RGdata.elementGeometries[i].pose.orientation.y << std::endl;
    std::cout << "      Size3D:" << std::endl;
    std::cout << "          l:" << m_RGdata.elementGeometries[i].size.l << std::endl;
    std::cout << "          w:" << m_RGdata.elementGeometries[i].size.w << std::endl;
    std::cout << "          h:" << m_RGdata.elementGeometries[i].size.h << std::endl;
  }

  m_RGdataOut.write();
  sleep(5);

  return RTC::RTC_OK;
}

/*
RTC::ReturnCode_t RangerGeometryOut::onAborting(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t RangerGeometryOut::onError(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t RangerGeometryOut::onReset(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t RangerGeometryOut::onStateUpdate(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t RangerGeometryOut::onRateChanged(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/


extern "C"
{
 
  void RangerGeometryOutInit(RTC::Manager* manager)
  {
    coil::Properties profile(rangergeometryout_spec);
    manager->registerFactory(profile,
                             RTC::Create<RangerGeometryOut>,
                             RTC::Delete<RangerGeometryOut>);
  }
  
};



