// -*- C++ -*-
/*!
 * @file  RangerConfigIn.cpp * @brief InPort example component * $Date$ 
 *
 * $Id$ 
 */
#include "RangerConfigIn.h"

// Module specification
// <rtc-template block="module_spec">
static const char* rangerconfigin_spec[] =
  {
    "implementation_id", "RangerConfigIn",
    "type_name",         "RangerConfigIn",
    "description",       "InPort example component",
    "version",           "1.0",
    "vendor",            "NEC Soft Ltd",
    "category",          "example",
    "activity_type",     "SPORADIC",
    "kind",              "DataFlowComponent",
    "max_instance",      "1",
    "language",          "C++",
    "lang_type",         "compile",
    // Configuration variables
    ""
  };
// </rtc-template>

RangerConfigIn::RangerConfigIn(RTC::Manager* manager)
    // <rtc-template block="initializer">
  : RTC::DataFlowComponentBase(manager),
    m_RConfigIn("RConfig", m_RConfig)

    // </rtc-template>
{
}

RangerConfigIn::~RangerConfigIn()
{
}


RTC::ReturnCode_t RangerConfigIn::onInitialize()
{
  // Registration: InPort/OutPort/Service
  // <rtc-template block="registration">
  // Set InPort buffers
  addInPort("RConfig", m_RConfigIn);

  // Set OutPort buffer

  // Set service provider to Ports

  // Set service consumers to Ports

  // Set CORBA Service Ports

  // </rtc-template>

  // <rtc-template block="bind_config">
  // Bind variables and configuration variable

  // </rtc-template>
  return RTC::RTC_OK;
}


/*
RTC::ReturnCode_t RangerConfigIn::onFinalize()
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t RangerConfigIn::onStartup(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t RangerConfigIn::onShutdown(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t RangerConfigIn::onActivated(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t RangerConfigIn::onDeactivated(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/

RTC::ReturnCode_t RangerConfigIn::onExecute(RTC::UniqueId ec_id)
{
  if( m_RConfigIn.isNew() )
  {
    m_RConfigIn.read();

    std::cout << "RangerConfig Read" << std::endl;
    std::cout << "  minAngle:" << m_RConfig.minAngle << std::endl;
    std::cout << "  maxAngle:" << m_RConfig.maxAngle << std::endl;
    std::cout << "  angularRes:" << m_RConfig.angularRes << std::endl;
    std::cout << "  minRange:" << m_RConfig.minRange << std::endl;
    std::cout << "  maxRange:" << m_RConfig.maxRange << std::endl;
    std::cout << "  rangeRes:" << m_RConfig.rangeRes << std::endl;
    std::cout << "  frequency:" << m_RConfig.frequency << std::endl;

  }
  return RTC::RTC_OK;
}

/*
RTC::ReturnCode_t RangerConfigIn::onAborting(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t RangerConfigIn::onError(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t RangerConfigIn::onReset(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t RangerConfigIn::onStateUpdate(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t RangerConfigIn::onRateChanged(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/


extern "C"
{
 
  void RangerConfigInInit(RTC::Manager* manager)
  {
    coil::Properties profile(rangerconfigin_spec);
    manager->registerFactory(profile,
                             RTC::Create<RangerConfigIn>,
                             RTC::Delete<RangerConfigIn>);
  }
  
};



