// -*- C++ -*-
/*!
 * @file  SampleOctetSeqOut.cpp * @brief OutPort example component * $Date$ 
 *
 * $Id$ 
 */
#include "SampleOctetSeqOut.h"

// Module specification
// <rtc-template block="module_spec">
static const char* sampleoctetseqout_spec[] =
  {
    "implementation_id", "SampleOctetSeqOut",
    "type_name",         "SampleOctetSeqOut",
    "description",       "OutPort example component",
    "version",           "1.0",
    "vendor",            "NEC Soft Ltd",
    "category",          "example",
    "activity_type",     "SPORADIC",
    "kind",              "DataFlowComponent",
    "max_instance",      "1",
    "language",          "C++",
    "lang_type",         "compile",
    // Configuration variables
    ""
  };
// </rtc-template>

SampleOctetSeqOut::SampleOctetSeqOut(RTC::Manager* manager)
    // <rtc-template block="initializer">
  : RTC::DataFlowComponentBase(manager),
    m_OctetSeqOut("OctetSeq", m_OctetSeq)

    // </rtc-template>
{
}

SampleOctetSeqOut::~SampleOctetSeqOut()
{
}


RTC::ReturnCode_t SampleOctetSeqOut::onInitialize()
{
  // Registration: InPort/OutPort/Service
  // <rtc-template block="registration">
  // Set InPort buffers

  // Set OutPort buffer
  addOutPort("OctetSeq", m_OctetSeqOut);

  // Set service provider to Ports

  // Set service consumers to Ports

  // Set CORBA Service Ports

  // </rtc-template>

  // <rtc-template block="bind_config">
  // Bind variables and configuration variable

  // </rtc-template>
  return RTC::RTC_OK;
}


/*
RTC::ReturnCode_t SampleOctetSeqOut::onFinalize()
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t SampleOctetSeqOut::onStartup(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t SampleOctetSeqOut::onShutdown(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t SampleOctetSeqOut::onActivated(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t SampleOctetSeqOut::onDeactivated(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/

RTC::ReturnCode_t SampleOctetSeqOut::onExecute(RTC::UniqueId ec_id)
{
  int i, maxsize;
  
  //TimedOctetSeq
  m_OctetSeq.data.length(2);
  m_OctetSeq.data[0] = -128;
  m_OctetSeq.data[1] =  127;
#ifndef __T_KERNEL__  
  m_OctetSeqOut.write();
#endif
  std::cout << "TimedOctetSeq write" << std::endl;
  maxsize = m_OctetSeq.data.length();
  for(i = 0; i < maxsize; i++)
  {
    std::cout << i << ":" << (int)m_OctetSeq.data[i] << std::endl;
  }
  std::cout << std::endl;
#ifdef __T_KERNEL__  
  m_OctetSeqOut.write();
  sleep(5);
#endif
  
  return RTC::RTC_OK;
}

/*
RTC::ReturnCode_t SampleOctetSeqOut::onAborting(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t SampleOctetSeqOut::onError(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t SampleOctetSeqOut::onReset(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t SampleOctetSeqOut::onStateUpdate(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t SampleOctetSeqOut::onRateChanged(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/


extern "C"
{
 
  void SampleOctetSeqOutInit(RTC::Manager* manager)
  {
    coil::Properties profile(sampleoctetseqout_spec);
    manager->registerFactory(profile,
                             RTC::Create<SampleOctetSeqOut>,
                             RTC::Delete<SampleOctetSeqOut>);
  }
  
};



