// -*- C++ -*-
/*!
 * @file  MemleakULongIn.cpp * @brief InPort example component * $Date$ 
 *
 * $Id$ 
 */
#include "MemleakULongIn.h"

// Module specification
// <rtc-template block="module_spec">
static const char* memleakulongin_spec[] =
  {
    "implementation_id", "MemleakULongIn",
    "type_name",         "MemleakULongIn",
    "description",       "InPort example component",
    "version",           "1.0",
    "vendor",            "NEC Soft Ltd",
    "category",          "example",
    "activity_type",     "SPORADIC",
    "kind",              "DataFlowComponent",
    "max_instance",      "1",
    "language",          "C++",
    "lang_type",         "compile",
    // Configuration variables
    ""
  };
// </rtc-template>

MemleakULongIn::MemleakULongIn(RTC::Manager* manager)
    // <rtc-template block="initializer">
  : RTC::DataFlowComponentBase(manager),
    m_dataIn("data", m_data)

    // </rtc-template>
{
#ifdef __T_KERNEL__
  m_ulongCnt = 0;
#endif
}

MemleakULongIn::~MemleakULongIn()
{
}


RTC::ReturnCode_t MemleakULongIn::onInitialize()
{
  // Registration: InPort/OutPort/Service
  // <rtc-template block="registration">
  // Set InPort buffers
  addInPort("data", m_dataIn);

  // Set OutPort buffer

  // Set service provider to Ports

  // Set service consumers to Ports

  // Set CORBA Service Ports

  // </rtc-template>

  // <rtc-template block="bind_config">
  // Bind variables and configuration variable

  // </rtc-template>
  return RTC::RTC_OK;
}


/*
RTC::ReturnCode_t MemleakULongIn::onFinalize()
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t MemleakULongIn::onStartup(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t MemleakULongIn::onShutdown(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t MemleakULongIn::onActivated(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t MemleakULongIn::onDeactivated(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/

RTC::ReturnCode_t MemleakULongIn::onExecute(RTC::UniqueId ec_id)
{
  if( m_dataIn.isNew() )
  {
    m_dataIn.read();
#ifdef __T_KERNEL__
    m_ulongCnt++;
    if(m_ulongCnt > 100)
    {
      printf("TimedULong %u\n", m_data.data);
      m_ulongCnt = 0;
    }
#else
    printf("TimedULong %u\n", m_data.data);
#endif
  }
  
  return RTC::RTC_OK;
}

/*
RTC::ReturnCode_t MemleakULongIn::onAborting(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t MemleakULongIn::onError(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t MemleakULongIn::onReset(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t MemleakULongIn::onStateUpdate(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t MemleakULongIn::onRateChanged(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/


extern "C"
{
 
  void MemleakULongInInit(RTC::Manager* manager)
  {
    coil::Properties profile(memleakulongin_spec);
    manager->registerFactory(profile,
                             RTC::Create<MemleakULongIn>,
                             RTC::Delete<MemleakULongIn>);
  }
  
};



