// -*- C++ -*-
/*!
 * @file  MemleakShortOut.cpp * @brief OutPort example component * $Date$ 
 *
 * $Id$ 
 */
#include "MemleakShortOut.h"

// Module specification
// <rtc-template block="module_spec">
static const char* memleakshortout_spec[] =
  {
    "implementation_id", "MemleakShortOut",
    "type_name",         "MemleakShortOut",
    "description",       "OutPort example component",
    "version",           "1.0",
    "vendor",            "NEC Soft Ltd",
    "category",          "example",
    "activity_type",     "SPORADIC",
    "kind",              "DataFlowComponent",
    "max_instance",      "1",
    "language",          "C++",
    "lang_type",         "compile",
    // Configuration variables
    ""
  };
// </rtc-template>

MemleakShortOut::MemleakShortOut(RTC::Manager* manager)
    // <rtc-template block="initializer">
  : RTC::DataFlowComponentBase(manager),
    m_dataOut("data", m_data)

    // </rtc-template>
{
}

MemleakShortOut::~MemleakShortOut()
{
}


RTC::ReturnCode_t MemleakShortOut::onInitialize()
{
  // Registration: InPort/OutPort/Service
  // <rtc-template block="registration">
  // Set InPort buffers

  // Set OutPort buffer
  addOutPort("data", m_dataOut);

  // Set service provider to Ports

  // Set service consumers to Ports

  // Set CORBA Service Ports

  // </rtc-template>

  // <rtc-template block="bind_config">
  // Bind variables and configuration variable

  // </rtc-template>
  return RTC::RTC_OK;
}


/*
RTC::ReturnCode_t MemleakShortOut::onFinalize()
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t MemleakShortOut::onStartup(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t MemleakShortOut::onShutdown(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t MemleakShortOut::onActivated(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t MemleakShortOut::onDeactivated(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/

RTC::ReturnCode_t MemleakShortOut::onExecute(RTC::UniqueId ec_id)
{
  m_data.data = 100;
  m_dataOut.write();
  
  return RTC::RTC_OK;
}

/*
RTC::ReturnCode_t MemleakShortOut::onAborting(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t MemleakShortOut::onError(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t MemleakShortOut::onReset(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t MemleakShortOut::onStateUpdate(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t MemleakShortOut::onRateChanged(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/


extern "C"
{
 
  void MemleakShortOutInit(RTC::Manager* manager)
  {
    coil::Properties profile(memleakshortout_spec);
    manager->registerFactory(profile,
                             RTC::Create<MemleakShortOut>,
                             RTC::Delete<MemleakShortOut>);
  }
  
};



