// -*- C++ -*-
/*!
 * @file  MemleakFloatSeqIn.cpp * @brief InPort example component * $Date$ 
 *
 * $Id$ 
 */
#include "MemleakFloatSeqIn.h"

// Module specification
// <rtc-template block="module_spec">
static const char* memleakfloatseqin_spec[] =
  {
    "implementation_id", "MemleakFloatSeqIn",
    "type_name",         "MemleakFloatSeqIn",
    "description",       "InPort example component",
    "version",           "1.0",
    "vendor",            "NEC Soft Ltd",
    "category",          "example",
    "activity_type",     "SPORADIC",
    "kind",              "DataFlowComponent",
    "max_instance",      "1",
    "language",          "C++",
    "lang_type",         "compile",
    // Configuration variables
    ""
  };
// </rtc-template>

MemleakFloatSeqIn::MemleakFloatSeqIn(RTC::Manager* manager)
    // <rtc-template block="initializer">
  : RTC::DataFlowComponentBase(manager),
    m_dataIn("data", m_data)

    // </rtc-template>
{
#ifdef __T_KERNEL__
  m_floatCnt = 0;
#endif
}

MemleakFloatSeqIn::~MemleakFloatSeqIn()
{
}


RTC::ReturnCode_t MemleakFloatSeqIn::onInitialize()
{
  // Registration: InPort/OutPort/Service
  // <rtc-template block="registration">
  // Set InPort buffers
  addInPort("data", m_dataIn);

  // Set OutPort buffer

  // Set service provider to Ports

  // Set service consumers to Ports

  // Set CORBA Service Ports

  // </rtc-template>

  // <rtc-template block="bind_config">
  // Bind variables and configuration variable

  // </rtc-template>
  return RTC::RTC_OK;
}


/*
RTC::ReturnCode_t MemleakFloatSeqIn::onFinalize()
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t MemleakFloatSeqIn::onStartup(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t MemleakFloatSeqIn::onShutdown(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t MemleakFloatSeqIn::onActivated(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t MemleakFloatSeqIn::onDeactivated(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/

RTC::ReturnCode_t MemleakFloatSeqIn::onExecute(RTC::UniqueId ec_id)
{
  int i, size;
  
  if( m_dataIn.isNew() )
  {
    m_dataIn.read();
#ifndef __T_KERNEL__
    printf("TimedFloatSeq\n");
#endif
    size = m_data.data.length();
    for(i = 0; i < size; i++)
    {
#ifdef __T_KERNEL__
      m_floatCnt++;
      if(m_floatCnt > 100)
      {
        printf("%d:%e\n", i, m_data.data[i]);
        m_floatCnt = 0;
      }
#else
      printf("%d:%e\n", i, m_data.data[i]);
#endif
    }
  }
  
  return RTC::RTC_OK;
}

/*
RTC::ReturnCode_t MemleakFloatSeqIn::onAborting(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t MemleakFloatSeqIn::onError(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t MemleakFloatSeqIn::onReset(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t MemleakFloatSeqIn::onStateUpdate(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t MemleakFloatSeqIn::onRateChanged(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/


extern "C"
{
 
  void MemleakFloatSeqInInit(RTC::Manager* manager)
  {
    coil::Properties profile(memleakfloatseqin_spec);
    manager->registerFactory(profile,
                             RTC::Create<MemleakFloatSeqIn>,
                             RTC::Delete<MemleakFloatSeqIn>);
  }
  
};



