// -*- C++ -*-
/*!
 * @file  MemleakDoubleIn.cpp * @brief InPort example component * $Date$ 
 *
 * $Id$ 
 */
#include "MemleakDoubleIn.h"

// Module specification
// <rtc-template block="module_spec">
static const char* memleakdoublein_spec[] =
  {
    "implementation_id", "MemleakDoubleIn",
    "type_name",         "MemleakDoubleIn",
    "description",       "InPort example component",
    "version",           "1.0",
    "vendor",            "NEC Soft Ltd",
    "category",          "example",
    "activity_type",     "SPORADIC",
    "kind",              "DataFlowComponent",
    "max_instance",      "1",
    "language",          "C++",
    "lang_type",         "compile",
    // Configuration variables
    ""
  };
// </rtc-template>

MemleakDoubleIn::MemleakDoubleIn(RTC::Manager* manager)
    // <rtc-template block="initializer">
  : RTC::DataFlowComponentBase(manager),
    m_dataIn("data", m_data)

    // </rtc-template>
{
#ifdef __T_KERNEL__
  m_doubleCnt = 0;
#endif
}

MemleakDoubleIn::~MemleakDoubleIn()
{
}


RTC::ReturnCode_t MemleakDoubleIn::onInitialize()
{
  // Registration: InPort/OutPort/Service
  // <rtc-template block="registration">
  // Set InPort buffers
  addInPort("data", m_dataIn);

  // Set OutPort buffer

  // Set service provider to Ports

  // Set service consumers to Ports

  // Set CORBA Service Ports

  // </rtc-template>

  // <rtc-template block="bind_config">
  // Bind variables and configuration variable

  // </rtc-template>
  return RTC::RTC_OK;
}


/*
RTC::ReturnCode_t MemleakDoubleIn::onFinalize()
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t MemleakDoubleIn::onStartup(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t MemleakDoubleIn::onShutdown(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t MemleakDoubleIn::onActivated(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t MemleakDoubleIn::onDeactivated(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/

RTC::ReturnCode_t MemleakDoubleIn::onExecute(RTC::UniqueId ec_id)
{
  if( m_dataIn.isNew() )
  {
    m_dataIn.read();
#ifdef __T_KERNEL__
    m_doubleCnt++;
    if(m_doubleCnt > 100)
    {
      printf("TimedDouble %e\n", m_data.data);
      m_doubleCnt = 0;
    }
#else
    printf("TimedDouble %e\n", m_data.data);
#endif
  }
  
  return RTC::RTC_OK;
}

/*
RTC::ReturnCode_t MemleakDoubleIn::onAborting(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t MemleakDoubleIn::onError(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t MemleakDoubleIn::onReset(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t MemleakDoubleIn::onStateUpdate(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t MemleakDoubleIn::onRateChanged(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/


extern "C"
{
 
  void MemleakDoubleInInit(RTC::Manager* manager)
  {
    coil::Properties profile(memleakdoublein_spec);
    manager->registerFactory(profile,
                             RTC::Create<MemleakDoubleIn>,
                             RTC::Delete<MemleakDoubleIn>);
  }
  
};



