// -*- C++ -*-
/*!
 * @file  MemleakBooleanSeqIn.cpp * @brief InPort example component * $Date$ 
 *
 * $Id$ 
 */
#include "MemleakBooleanSeqIn.h"

// Module specification
// <rtc-template block="module_spec">
static const char* memleakbooleanseqin_spec[] =
  {
    "implementation_id", "MemleakBooleanSeqIn",
    "type_name",         "MemleakBooleanSeqIn",
    "description",       "InPort example component",
    "version",           "1.0",
    "vendor",            "NEC Soft Ltd",
    "category",          "example",
    "activity_type",     "SPORADIC",
    "kind",              "DataFlowComponent",
    "max_instance",      "1",
    "language",          "C++",
    "lang_type",         "compile",
    // Configuration variables
    ""
  };
// </rtc-template>

MemleakBooleanSeqIn::MemleakBooleanSeqIn(RTC::Manager* manager)
    // <rtc-template block="initializer">
  : RTC::DataFlowComponentBase(manager),
    m_dataIn("data", m_data)

    // </rtc-template>
{
#ifdef __T_KERNEL__
  m_trueCnt = 0;
  m_falseCnt = 0;
#endif
}

MemleakBooleanSeqIn::~MemleakBooleanSeqIn()
{
}


RTC::ReturnCode_t MemleakBooleanSeqIn::onInitialize()
{
  // Registration: InPort/OutPort/Service
  // <rtc-template block="registration">
  // Set InPort buffers
  addInPort("data", m_dataIn);

  // Set OutPort buffer

  // Set service provider to Ports

  // Set service consumers to Ports

  // Set CORBA Service Ports

  // </rtc-template>

  // <rtc-template block="bind_config">
  // Bind variables and configuration variable

  // </rtc-template>
  return RTC::RTC_OK;
}


/*
RTC::ReturnCode_t MemleakBooleanSeqIn::onFinalize()
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t MemleakBooleanSeqIn::onStartup(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t MemleakBooleanSeqIn::onShutdown(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t MemleakBooleanSeqIn::onActivated(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t MemleakBooleanSeqIn::onDeactivated(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/

RTC::ReturnCode_t MemleakBooleanSeqIn::onExecute(RTC::UniqueId ec_id)
{
  int i, size;
  
  if( m_dataIn.isNew() )
  {
    m_dataIn.read();
#ifndef __T_KERNEL__
    printf("TimedBooleanSeq\n");
#endif
    size = m_data.data.length();
    for(i = 0; i < size; i++)
    {
      if(m_data.data[i] == true)
      {
#ifdef __T_KERNEL__
        m_trueCnt++;
#else
        printf("%d:true\n", i);
#endif
      }else{
#ifdef __T_KERNEL__
        m_falseCnt++;
#else
        printf("%d:false\n", i);
#endif
      }
    }
#ifdef __T_KERNEL__
    if( m_trueCnt > 100)
    {
      printf("TimedBooleanSeq true\n");
      m_trueCnt = 0;
    }
    if( m_falseCnt > 100)
    {
      printf("TimedBooleanSeq false\n");
      m_falseCnt = 0;
    }
#endif
  }
  
  return RTC::RTC_OK;
}

/*
RTC::ReturnCode_t MemleakBooleanSeqIn::onAborting(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t MemleakBooleanSeqIn::onError(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t MemleakBooleanSeqIn::onReset(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t MemleakBooleanSeqIn::onStateUpdate(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t MemleakBooleanSeqIn::onRateChanged(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/


extern "C"
{
 
  void MemleakBooleanSeqInInit(RTC::Manager* manager)
  {
    coil::Properties profile(memleakbooleanseqin_spec);
    manager->registerFactory(profile,
                             RTC::Create<MemleakBooleanSeqIn>,
                             RTC::Delete<MemleakBooleanSeqIn>);
  }
  
};



