// -*- C++ -*-
/*!
 * @file  BorderUShortOut.cpp * @brief OutPort example component * $Date$ 
 *
 * $Id$ 
 */
#include "BorderUShortOut.h"

// Module specification
// <rtc-template block="module_spec">
static const char* borderushortout_spec[] =
  {
    "implementation_id", "BorderUShortOut",
    "type_name",         "BorderUShortOut",
    "description",       "OutPort example component",
    "version",           "1.0",
    "vendor",            "NEC Soft Ltd",
    "category",          "example",
    "activity_type",     "SPORADIC",
    "kind",              "DataFlowComponent",
    "max_instance",      "1",
    "language",          "C++",
    "lang_type",         "compile",
    // Configuration variables
    ""
  };
// </rtc-template>

BorderUShortOut::BorderUShortOut(RTC::Manager* manager)
    // <rtc-template block="initializer">
  : RTC::DataFlowComponentBase(manager),
    m_UShortDataOut("UShortData", m_UShortData)

    // </rtc-template>
{
}

BorderUShortOut::~BorderUShortOut()
{
}


RTC::ReturnCode_t BorderUShortOut::onInitialize()
{
  // Registration: InPort/OutPort/Service
  // <rtc-template block="registration">
  // Set InPort buffers

  // Set OutPort buffer
  addOutPort("UShortData", m_UShortDataOut);

  // Set service provider to Ports

  // Set service consumers to Ports

  // Set CORBA Service Ports

  // </rtc-template>

  // <rtc-template block="bind_config">
  // Bind variables and configuration variable

  // </rtc-template>
  return RTC::RTC_OK;
}


/*
RTC::ReturnCode_t BorderUShortOut::onFinalize()
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t BorderUShortOut::onStartup(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t BorderUShortOut::onShutdown(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t BorderUShortOut::onActivated(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t BorderUShortOut::onDeactivated(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/

RTC::ReturnCode_t BorderUShortOut::onExecute(RTC::UniqueId ec_id)
{
  //TimedUShort
  m_UShortData.data = 0;
#ifndef __T_KERNEL__
  m_UShortDataOut.write();
#endif
  
  printf("TimedUShort write\n");
  printf("TimedUShort %u\n",m_UShortData.data);
#ifdef __T_KERNEL__
  m_UShortDataOut.write();
  sleep(3);
#endif
  
  m_UShortData.data = 65535;
#ifndef __T_KERNEL__
  m_UShortDataOut.write();
#endif
  
  printf("TimedUShort write\n");
  printf("TimedUShort %u\n",m_UShortData.data);
#ifdef __T_KERNEL__
  m_UShortDataOut.write();
  sleep(3);
#endif
  
  return RTC::RTC_OK;
}

/*
RTC::ReturnCode_t BorderUShortOut::onAborting(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t BorderUShortOut::onError(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t BorderUShortOut::onReset(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t BorderUShortOut::onStateUpdate(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t BorderUShortOut::onRateChanged(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/


extern "C"
{
 
  void BorderUShortOutInit(RTC::Manager* manager)
  {
    coil::Properties profile(borderushortout_spec);
    manager->registerFactory(profile,
                             RTC::Create<BorderUShortOut>,
                             RTC::Delete<BorderUShortOut>);
  }
  
};



