// -*- C++ -*-
/*!
 * @file  BorderULongOut.cpp * @brief OutPort example component * $Date$ 
 *
 * $Id$ 
 */
#include "BorderULongOut.h"

// Module specification
// <rtc-template block="module_spec">
static const char* borderulongout_spec[] =
  {
    "implementation_id", "BorderULongOut",
    "type_name",         "BorderULongOut",
    "description",       "OutPort example component",
    "version",           "1.0",
    "vendor",            "NEC Soft Ltd",
    "category",          "example",
    "activity_type",     "SPORADIC",
    "kind",              "DataFlowComponent",
    "max_instance",      "1",
    "language",          "C++",
    "lang_type",         "compile",
    // Configuration variables
    ""
  };
// </rtc-template>

BorderULongOut::BorderULongOut(RTC::Manager* manager)
    // <rtc-template block="initializer">
  : RTC::DataFlowComponentBase(manager),
    m_ULongDataOut("ULongData", m_ULongData)

    // </rtc-template>
{
}

BorderULongOut::~BorderULongOut()
{
}


RTC::ReturnCode_t BorderULongOut::onInitialize()
{
  // Registration: InPort/OutPort/Service
  // <rtc-template block="registration">
  // Set InPort buffers

  // Set OutPort buffer
  addOutPort("ULongData", m_ULongDataOut);

  // Set service provider to Ports

  // Set service consumers to Ports

  // Set CORBA Service Ports

  // </rtc-template>

  // <rtc-template block="bind_config">
  // Bind variables and configuration variable

  // </rtc-template>
  return RTC::RTC_OK;
}


/*
RTC::ReturnCode_t BorderULongOut::onFinalize()
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t BorderULongOut::onStartup(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t BorderULongOut::onShutdown(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t BorderULongOut::onActivated(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t BorderULongOut::onDeactivated(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/

RTC::ReturnCode_t BorderULongOut::onExecute(RTC::UniqueId ec_id)
{
  
  //TimedULong
  m_ULongData.data = 0;
#ifndef __T_KERNEL__
  m_ULongDataOut.write();
#endif
  
  printf("TimedULong write\n");
  printf("TimedULong %u\n",m_ULongData.data);
#ifdef __T_KERNEL__
  m_ULongDataOut.write();
  sleep(3);
#endif
  
  m_ULongData.data = 4294967295;
#ifndef __T_KERNEL__
  m_ULongDataOut.write();
#endif
  
  printf("TimedULong write\n");
  printf("TimedULong %u\n",m_ULongData.data);
#ifdef __T_KERNEL__
  m_ULongDataOut.write();
  sleep(3);
#endif
  
  return RTC::RTC_OK;
}

/*
RTC::ReturnCode_t BorderULongOut::onAborting(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t BorderULongOut::onError(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t BorderULongOut::onReset(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t BorderULongOut::onStateUpdate(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t BorderULongOut::onRateChanged(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/


extern "C"
{
 
  void BorderULongOutInit(RTC::Manager* manager)
  {
    coil::Properties profile(borderulongout_spec);
    manager->registerFactory(profile,
                             RTC::Create<BorderULongOut>,
                             RTC::Delete<BorderULongOut>);
  }
  
};



