// -*- C++ -*-
/*!
 * @file  BorderLongOut.cpp * @brief OutPort example component * $Date$ 
 *
 * $Id$ 
 */
#include "BorderLongOut.h"

// Module specification
// <rtc-template block="module_spec">
static const char* borderlongout_spec[] =
  {
    "implementation_id", "BorderLongOut",
    "type_name",         "BorderLongOut",
    "description",       "OutPort example component",
    "version",           "1.0",
    "vendor",            "NEC Soft Ltd",
    "category",          "example",
    "activity_type",     "SPORADIC",
    "kind",              "DataFlowComponent",
    "max_instance",      "1",
    "language",          "C++",
    "lang_type",         "compile",
    // Configuration variables
    ""
  };
// </rtc-template>

BorderLongOut::BorderLongOut(RTC::Manager* manager)
    // <rtc-template block="initializer">
  : RTC::DataFlowComponentBase(manager),
    m_LongDataOut("LongData", m_LongData)

    // </rtc-template>
{
}

BorderLongOut::~BorderLongOut()
{
}


RTC::ReturnCode_t BorderLongOut::onInitialize()
{
  // Registration: InPort/OutPort/Service
  // <rtc-template block="registration">
  // Set InPort buffers

  // Set OutPort buffer
  addOutPort("LongData", m_LongDataOut);

  // Set service provider to Ports

  // Set service consumers to Ports

  // Set CORBA Service Ports

  // </rtc-template>

  // <rtc-template block="bind_config">
  // Bind variables and configuration variable

  // </rtc-template>
  return RTC::RTC_OK;
}


/*
RTC::ReturnCode_t BorderLongOut::onFinalize()
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t BorderLongOut::onStartup(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t BorderLongOut::onShutdown(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t BorderLongOut::onActivated(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t BorderLongOut::onDeactivated(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/

RTC::ReturnCode_t BorderLongOut::onExecute(RTC::UniqueId ec_id)
{
  //TimedLong
  m_LongData.data = -2147483648;
#ifndef __T_KERNEL__
  m_LongDataOut.write();
#endif
  
  printf("TimedLong write\n");
  printf("TimedLong %d\n",m_LongData.data);

#ifdef __T_KERNEL__
  m_LongDataOut.write();
  sleep(3);
#endif
  
  m_LongData.data = 2147483647;
#ifndef __T_KERNEL__
  m_LongDataOut.write();
#endif
  
  printf("TimedLong write\n");
  printf("TimedLong %d\n",m_LongData.data);

#ifdef __T_KERNEL__
  m_LongDataOut.write();
  sleep(3);
#endif
  
  return RTC::RTC_OK;
}

/*
RTC::ReturnCode_t BorderLongOut::onAborting(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t BorderLongOut::onError(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t BorderLongOut::onReset(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t BorderLongOut::onStateUpdate(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t BorderLongOut::onRateChanged(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/


extern "C"
{
 
  void BorderLongOutInit(RTC::Manager* manager)
  {
    coil::Properties profile(borderlongout_spec);
    manager->registerFactory(profile,
                             RTC::Create<BorderLongOut>,
                             RTC::Delete<BorderLongOut>);
  }
  
};



