// -*- C++ -*-
/*!
 * @file  BorderIn.cpp * @brief InPort example component * $Date$ 
 *
 * $Id$ 
 */
#include "BorderIn.h"

// Module specification
// <rtc-template block="module_spec">
static const char* borderin_spec[] =
  {
    "implementation_id", "BorderIn",
    "type_name",         "BorderIn",
    "description",       "InPort example component",
    "version",           "1.0",
    "vendor",            "NEC Soft Ltd",
    "category",          "example",
    "activity_type",     "SPORADIC",
    "kind",              "DataFlowComponent",
    "max_instance",      "1",
    "language",          "C++",
    "lang_type",         "compile",
    // Configuration variables
    ""
  };
// </rtc-template>

BorderIn::BorderIn(RTC::Manager* manager)
    // <rtc-template block="initializer">
  : RTC::DataFlowComponentBase(manager),
    m_CharDataIn("CharData", m_CharData),
    m_ShortDataIn("ShortData", m_ShortData),
    m_LongDataIn("LongData", m_LongData),
    m_UShortDataIn("UShortData", m_UShortData),
    m_ULongDataIn("ULongData", m_ULongData),
    m_FloatDataIn("FloatData", m_FloatData),
    m_DoubleDataIn("DoubleData", m_DoubleData)

    // </rtc-template>
{
}

BorderIn::~BorderIn()
{
}


RTC::ReturnCode_t BorderIn::onInitialize()
{
  // Registration: InPort/OutPort/Service
  // <rtc-template block="registration">
  // Set InPort buffers
  addInPort("CharData", m_CharDataIn);
  addInPort("ShortData", m_ShortDataIn);
  addInPort("LongData", m_LongDataIn);
  addInPort("UShortData", m_UShortDataIn);
  addInPort("ULongData", m_ULongDataIn);
  addInPort("FloatData", m_FloatDataIn);
  addInPort("DoubleData", m_DoubleDataIn);

  // Set OutPort buffer

  // Set service provider to Ports

  // Set service consumers to Ports

  // Set CORBA Service Ports

  // </rtc-template>

  // <rtc-template block="bind_config">
  // Bind variables and configuration variable

  // </rtc-template>
  return RTC::RTC_OK;
}


/*
RTC::ReturnCode_t BorderIn::onFinalize()
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t BorderIn::onStartup(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t BorderIn::onShutdown(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t BorderIn::onActivated(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t BorderIn::onDeactivated(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/

RTC::ReturnCode_t BorderIn::onExecute(RTC::UniqueId ec_id)
{
  if( m_CharDataIn.isNew() )
  {
    m_CharDataIn.read();
    printf("TimedChar read\n");
    printf("TimedChar: %d\n", m_CharData.data);
  }
  
  if( m_ShortDataIn.isNew() )
  {
    m_ShortDataIn.read();
    printf("TimedShort read\n");
    printf("TimedShort: %d\n", m_ShortData.data);
  }
  
  if( m_LongDataIn.isNew() )
  {
    m_LongDataIn.read();
    printf("TimedLong read\n");
    printf("TimedLong: %d\n", m_LongData.data);
  }
  
  if( m_UShortDataIn.isNew() )
  {
    m_UShortDataIn.read();
    printf("TimedUShort read\n");
    printf("TimedUShort: %u\n", m_UShortData.data);
  }
  
  if( m_ULongDataIn.isNew() )
  {
    m_ULongDataIn.read();
    printf("TimedULong read\n");
    printf("TimedULong: %u\n", m_ULongData.data);
  }
  
  if( m_FloatDataIn.isNew() )
  {
    m_FloatDataIn.read();
    printf("TimedFloat read\n");
    printf("TimedFloat: %e\n", m_FloatData.data);
  }
  
  if( m_DoubleDataIn.isNew() )
  {
    m_DoubleDataIn.read();
    printf("TimedDouble read\n");
    printf("TimedDouble: %e\n", m_DoubleData.data);
  }
  
  return RTC::RTC_OK;
}

/*
RTC::ReturnCode_t BorderIn::onAborting(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t BorderIn::onError(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t BorderIn::onReset(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t BorderIn::onStateUpdate(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t BorderIn::onRateChanged(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/


extern "C"
{
 
  void BorderInInit(RTC::Manager* manager)
  {
    coil::Properties profile(borderin_spec);
    manager->registerFactory(profile,
                             RTC::Create<BorderIn>,
                             RTC::Delete<BorderIn>);
  }
  
};



