// -*- C++ -*-
/*!
 * @file  BorderCharOut.cpp * @brief OutPort example component * $Date$ 
 *
 * $Id$ 
 */
#include "BorderCharOut.h"

// Module specification
// <rtc-template block="module_spec">
static const char* bordercharout_spec[] =
  {
    "implementation_id", "BorderCharOut",
    "type_name",         "BorderCharOut",
    "description",       "OutPort example component",
    "version",           "1.0",
    "vendor",            "NEC Soft Ltd",
    "category",          "example",
    "activity_type",     "SPORADIC",
    "kind",              "DataFlowComponent",
    "max_instance",      "1",
    "language",          "C++",
    "lang_type",         "compile",
    // Configuration variables
    ""
  };
// </rtc-template>

BorderCharOut::BorderCharOut(RTC::Manager* manager)
    // <rtc-template block="initializer">
  : RTC::DataFlowComponentBase(manager),
    m_CharDataOut("CharData", m_CharData)

    // </rtc-template>
{
}

BorderCharOut::~BorderCharOut()
{
}


RTC::ReturnCode_t BorderCharOut::onInitialize()
{
  // Registration: InPort/OutPort/Service
  // <rtc-template block="registration">
  // Set InPort buffers

  // Set OutPort buffer
  addOutPort("CharData", m_CharDataOut);

  // Set service provider to Ports

  // Set service consumers to Ports

  // Set CORBA Service Ports

  // </rtc-template>

  // <rtc-template block="bind_config">
  // Bind variables and configuration variable

  // </rtc-template>
  return RTC::RTC_OK;
}


/*
RTC::ReturnCode_t BorderCharOut::onFinalize()
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t BorderCharOut::onStartup(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t BorderCharOut::onShutdown(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t BorderCharOut::onActivated(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t BorderCharOut::onDeactivated(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/

RTC::ReturnCode_t BorderCharOut::onExecute(RTC::UniqueId ec_id)
{
  //TimedChar
  m_CharData.data = -128;
#ifndef __T_KERNEL__
  m_CharDataOut.write();
#endif
  
  printf("TimedChar write\n");
  printf("TimedChar %d\n", m_CharData.data);

#ifdef __T_KERNEL__
  m_CharDataOut.write();
  sleep(3);
#endif
  
  m_CharData.data = 127;
#ifndef __T_KERNEL__
  m_CharDataOut.write();
#endif
  
  printf("TimedChar write\n");
  printf("TimedChar %d\n", m_CharData.data);

#ifdef __T_KERNEL__
  m_CharDataOut.write();
  sleep(3);
#endif
  
  return RTC::RTC_OK;
}

/*
RTC::ReturnCode_t BorderCharOut::onAborting(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t BorderCharOut::onError(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t BorderCharOut::onReset(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t BorderCharOut::onStateUpdate(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/
/*
RTC::ReturnCode_t BorderCharOut::onRateChanged(RTC::UniqueId ec_id)
{
  return RTC::RTC_OK;
}
*/


extern "C"
{
 
  void BorderCharOutInit(RTC::Manager* manager)
  {
    coil::Properties profile(bordercharout_spec);
    manager->registerFactory(profile,
                             RTC::Create<BorderCharOut>,
                             RTC::Delete<BorderCharOut>);
  }
  
};



