// -*- C++ -*-
/*!
 * @file  ActionSample.cpp * @brief Action example component * $Date$ 
 *
 * $Id$ 
 */
#include "ActionSample.h"

#ifdef DEBUG
#include <util/tmonitor.h>
#endif

// Module specification
// <rtc-template block="module_spec">
static const char* actionsample_spec[] =
  {
    "implementation_id", "ActionSample",
    "type_name",         "ActionSample",
    "description",       "Action example component",
    "version",           "1.0",
    "vendor",            "NEC Soft Ltd",
    "category",          "example",
    "activity_type",     "SPORADIC",
    "kind",              "DataFlowComponent",
    "max_instance",      "1",
    "language",          "C++",
    "lang_type",         "compile",
    // Configuration variables
    ""
  };
// </rtc-template>

ActionSample::ActionSample(RTC::Manager* manager)
    // <rtc-template block="initializer">
  : RTC::DataFlowComponentBase(manager)
    // </rtc-template>
{
  // Registration: InPort/OutPort/Service
  // <rtc-template block="registration">
  // Set InPort buffers

  // Set OutPort buffer

  // Set service provider to Ports

  // Set service consumers to Ports

  // Set CORBA Service Ports

  // </rtc-template>

}

ActionSample::~ActionSample()
{
}


RTC::ReturnCode_t ActionSample::onInitialize()
{
  // <rtc-template block="bind_config">
  // Bind variables and configuration variable

  // </rtc-template>
  std::cout << "onInitialize START" << std::endl;
  onExecuteFlag = false;
  onStateUpdateFlag = false;
  onErrorFlag = false;
  onErrorCnt = 0;
  std::cout << "onInitialize END" << std::endl;
  return RTC::RTC_OK;
}



RTC::ReturnCode_t ActionSample::onFinalize()
{
  std::cout << "onFinalize START" << std::endl;
  std::cout << "onFinalize END" << std::endl;
  return RTC::RTC_OK;
}

RTC::ReturnCode_t ActionSample::onStartup(RTC::UniqueId ec_id)
{
  std::cout << "onStartup START" << std::endl;
  std::cout << "onStartup END" << std::endl;
  return RTC::RTC_OK;
}

RTC::ReturnCode_t ActionSample::onShutdown(RTC::UniqueId ec_id)
{
#ifdef DEBUG
//DEL tm_monitor();
#endif
  std::cout << "onShutdown START" << std::endl;
  std::cout << "onShutdown END" << std::endl;
  return RTC::RTC_OK;
}

RTC::ReturnCode_t ActionSample::onActivated(RTC::UniqueId ec_id)
{
  std::cout << "onActivated START" << std::endl;
  onExecuteFlag = false;
  onStateUpdateFlag = false;
  std::cout << "onActivated END" << std::endl;
  return RTC::RTC_OK;
}

RTC::ReturnCode_t ActionSample::onDeactivated(RTC::UniqueId ec_id)
{
  std::cout << "onDeactivated START" << std::endl;
  onExecuteFlag = false;
  onStateUpdateFlag = false;
  onErrorCnt++;
  std::cout << "onDeactivated END" << std::endl;
  return RTC::RTC_OK;
}

RTC::ReturnCode_t ActionSample::onExecute(RTC::UniqueId ec_id)
{
  if(onExecuteFlag == false) std::cout << "onExecute START" << std::endl;
  if(onErrorCnt >= 1) return RTC::RTC_ERROR;
  if(onExecuteFlag == false) std::cout << "onExecute END" << std::endl;
  onExecuteFlag = true;
  return RTC::RTC_OK;
}

RTC::ReturnCode_t ActionSample::onAborting(RTC::UniqueId ec_id)
{
  std::cout << "onAborting START" << std::endl;
  std::cout << "onAborting END" << std::endl;
  return RTC::RTC_OK;
}

RTC::ReturnCode_t ActionSample::onError(RTC::UniqueId ec_id)
{
  if(onErrorFlag == false) std::cout << "onError START" << std::endl;
  onErrorCnt = 0;
  if(onErrorFlag == false) std::cout << "onError END" << std::endl;
  onErrorFlag = true;
  return RTC::RTC_OK;
}

RTC::ReturnCode_t ActionSample::onReset(RTC::UniqueId ec_id)
{
  std::cout << "onReset START" << std::endl;
  std::cout << "onReset END" << std::endl;
  return RTC::RTC_OK;
}

RTC::ReturnCode_t ActionSample::onStateUpdate(RTC::UniqueId ec_id)
{
  if(onStateUpdateFlag == false) std::cout << "onStateUpdate START" << std::endl;
  if(onStateUpdateFlag == false) std::cout << "onStateUpdate END" << std::endl;
  onStateUpdateFlag = true;
  return RTC::RTC_OK;
}

RTC::ReturnCode_t ActionSample::onRateChanged(RTC::UniqueId ec_id)
{
  std::cout << "onRateChanged START" << std::endl;
  std::cout << "onRateChanged END" << std::endl;
  return RTC::RTC_OK;
}



extern "C"
{
 
  void ActionSampleInit(RTC::Manager* manager)
  {
    RTC::Properties profile(actionsample_spec);
    manager->registerFactory(profile,
                             RTC::Create<ActionSample>,
                             RTC::Delete<ActionSample>);
  }
  
};



