/**
 * @file nes_posix_timeb.c
 * @brief This file is part of the posix library
 *
 * Copyright 2011 NEC Soft, Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include <extension/clk.h>
#include "nes_posix_timeb.h"

/**
 * nes_posix_ftime - Return current date and time in tp
 * @param *__timebuf	struct timeb pointer
 * @retval int ftime	Always return 0
 * 
 * @note
 */
int nes_posix_ftime(struct timeb *__timebuf)
{
	int ret = 0;
	STIME t = 0;
	TIMEZONE zone;	

	ret = tkse_get_tim2(&t,&zone);
	if( ret != 0 ) {
		return 0; /* ftime always return 0 */
	}
	/* Not support __timebuf.millitm */
	__timebuf->time 		= t;
	__timebuf->timezone 	= zone.adjust / 60; /* zone.adjust use seconds */
	__timebuf->dstflag 	= zone.dst_flg;
	return 0;
}
