/**
 * @file memory_check.h
 * @brief This file is part of the posix library
 *
 * Copyright 2011 NEC Soft, Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef __MEMORY_CHECK_H__
#define __MEMORY_CHECK_H__

#ifdef MEMORY_CHECK

#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <queue.h>

#ifdef __cplusplus
extern "C" {
#endif

#define  MC_MALLOC(size)		mc_malloc(__FILE__, __LINE__, size, #size)
#define  MC_CALLOC(num, size)	mc_malloc(__FILE__, __LINE__, size*num, #num#size)
#define  MC_FREE(p)			mc_free(p)

	int mc_init(void);
	void mc_showinfo(void);
	void mc_free(void* p);
	void* mc_malloc(const char* file, const int line, const int size, const char* exp);

#ifdef __cplusplus
}
#endif

#else  /* MEMORY_CHECK */

#define  MC_MALLOC(size)		malloc(size)
#define  MC_CALLOC(num, size)	calloc(num, size)
#define  MC_FREE(p)			free(p)

#endif 

#endif //__MEMORY_CHECK_H__
