/**
 * @file nes_posix_signal.h
 * @brief signal core header file
 *
 * Copyright 2011 NEC Soft, Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef __NES_POSIX_SIGNAL_H_
#define __NES_POSIX_SIGNAL_H_

#ifdef DEBUG
#ifdef NES_SE   /* Use Standard Extension */
#include <tm/tmonitor.h>
#else           /* Use PMC Extension */
#include <util/tmonitor.h>
#endif
#endif

#include <basic.h>
#include "nes_posix_siginfo.h"

#ifdef __cplusplus
extern "C" {
#endif

typedef __sighandler_t sighandler_t;		

extern int __init_sig_lib(void);				
extern void __finish_sig_lib(void);			
#define SIGNAL_INIT()  __init_sig_lib()		/* Signal libary init interface, NEED call when process begin */
#define SIGNAL_FINISH() __finish_sig_lib()	/* Signal libary clear interface, MANUL or AUTO called when process ended */

/*
 * Get current process id
 */
IMPORT int nes_posix_getpid(void);

/*
 * Sigset operations
 */
IMPORT int nes_posix_sigfillset(sigset_t* set);
IMPORT int nes_posix_sigemptyset(sigset_t* set);
IMPORT int nes_posix_sigaddset(sigset_t* set, int _sig);
IMPORT int nes_posix_sigdelset(sigset_t* set, int _sig);
IMPORT int nes_posix_sigismember(const sigset_t* set, int _sig);

IMPORT int nes_posix_sigorsets(const sigset_t *in1, const sigset_t *in2, sigset_t *out);
IMPORT int nes_posix_sigandsets(const sigset_t *in1, const sigset_t *in2, sigset_t *out);

/*
 * Signal control operations
 */

IMPORT int nes_posix_sigpending(sigset_t* set);
IMPORT int nes_posix_sigprocmask(int how, const sigset_t* set, sigset_t* oldset);
IMPORT sighandler_t nes_posix_signal(int signum, sighandler_t handler);
IMPORT int nes_posix_sigaction(int signum, const struct sigaction* act,  struct sigaction* oldact);

/*
 * Signal send operations
 */
IMPORT int nes_posix_raise(int signum);
IMPORT int nes_posix_kill(pid_t pid, int signum);
IMPORT unsigned int nes_posix_alarm(unsigned int seconds);
IMPORT int nes_posix_sigqueue(pid_t pid, int signum, const union sigval value);

/*
 * Signal wait operations
 */
IMPORT int nes_posix_pause(void);
IMPORT int nes_posix_sigsuspend(const sigset_t* set);

#ifdef __cplusplus
}
#endif

/*
 * Maxiaochen @ NECsoft (JiNan). 2008/07/11 append
*/
#ifdef __cplusplus
extern "C" {
#endif

IMPORT int getpid(void);
IMPORT int sigfillset(sigset_t* set);
IMPORT int sigemptyset(sigset_t* set);
IMPORT int sigaddset(sigset_t* set,int _sig);
IMPORT int sigdelset(sigset_t* set,int _sig);
IMPORT int sigismember(const sigset_t* set, int _sig);
IMPORT int sigorsets(const sigset_t* in1, const sigset_t* in2, sigset_t* out);
IMPORT int sigandsets(const sigset_t* in1, const sigset_t* in2, sigset_t* out);
IMPORT int sigpending(sigset_t* set);
IMPORT int sigprocmask(int how, const sigset_t* set, sigset_t* oldset);
IMPORT sighandler_t signal(int signum, sighandler_t handler);
IMPORT int sigaction(int signum, const struct sigaction* act,  struct sigaction* oldact);
IMPORT int raise(int signum);
IMPORT int kill(pid_t pid, int signum);
IMPORT unsigned int alarm(unsigned int seconds);
IMPORT int sigqueue(pid_t pid, int signum, const union sigval value);
IMPORT int pause(void);
IMPORT int sigsuspend(const sigset_t* set);

#ifdef __cplusplus
}
#endif
#endif //__MY_SIGNAL_H__
