/**
 * @file nes_posix_sched.h
 * @brief This file is part of the posix library
 *
 * Copyright 2011 NEC Soft, Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef __NES_POSIX_SCHED_H__
#define __NES_POSIX_SCHED_H__

//#include <unix/sys/time.h>
#include <typedef.h>
#include "nes_posix_proc.h"

#ifdef __cplusplus
extern "C" { 
#endif
	/* get the maximum rt_priority that can be used by a given scheduling class */
	IMPORT int nes_posix_sched_get_priority_max(int policy);

	/* get the minium rt_priority that can be used by a given scheduling class */
	IMPORT int nes_posix_sched_get_priority_min(int policy);

	/* writes the default timeslice value of a given process*/
	IMPORT int nes_posix_sched_rr_get_interval(pid_t pid, struct timespec *tp);

	/* the function this function yields the current CPU by
	   moving the calling thread to the expired array. If 
	   there are no other threads running on this CPU then 
	   this function will return.                   */
	IMPORT int nes_posix_sched_yield(void);
#ifdef __cplusplus
} 
#endif
/*
 * Maxiaochen @ NECsoft (JiNan). 2008/07/10 append
*/

#ifdef __cplusplus
extern "C" {
#endif

IMPORT int sched_get_priority_max(int policy);

IMPORT int sched_get_priority_min(int policy);

IMPORT int sched_rr_get_interval(pid_t pid, struct timespec* tp);

IMPORT int sched_yield(void);

#ifdef __cplusplus
}
#endif
#endif

