/**
 * @file nes_posix_error.h
 * @brief pthread libary error code define
 *
 * Copyright 2011 NEC Soft, Ltd.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
#ifndef __NES_POSIX_ERRNO_H_
#define __NES_POSIX_ERRNO_H_

#ifdef __cplusplus
extern "C" { 
#endif

#ifdef NES_SE   /* Use Standard Extension */
#include <tk/errno.h>
#include <tkse/errno.h>
#include <tkse/extension/errno.h>
#else           /* Use PMC Extension */
#include <errno.h>
#endif

#ifndef EAGAIN
#define	EAGAIN		66	/* Try again */
#endif
#define	EDEADLOCK		EDEADLK
#define	ECHILD		10	/* No child processes */

#ifdef __cplusplus
}
#endif

#endif //__NES_POSIX_ERRNO_H_







