// -*- C++ -*-
/*!
 * @file  rtc_hokuyoaist.h * @brief Hokuyo laser scanner component. * @date  $Date$ 
 *
 * $Id$ 
 */
#ifndef RTC_HOKUYOAIST_H
#define RTC_HOKUYOAIST_H

#ifdef __T_KERNEL__
#include <hokuyo_aist/hokuyo_aist.h>
#endif
#include <rtm/idl/BasicDataTypeSkel.h>
#include <rtm/Manager.h>
#include <rtm/DataFlowComponentBase.h>
#include <rtm/CorbaPort.h>
#include <rtm/DataInPort.h>
#include <rtm/DataOutPort.h>

// Service implementation headers
// <rtc-template block="service_impl_h">
#include "hokuyoaistSVC_impl.h"
#include "rangerSVC_impl.h"

// </rtc-template>

// Service Consumer stub headers
// <rtc-template block="consumer_stub_h">

// </rtc-template>

using namespace RTC;

class rtc_hokuyoaist  : public RTC::DataFlowComponentBase
{
 public:
  rtc_hokuyoaist(RTC::Manager* manager);
  ~rtc_hokuyoaist();

  // The initialize action (on CREATED->ALIVE transition)
  // formaer rtc_init_entry() 
 virtual RTC::ReturnCode_t onInitialize();

  // The finalize action (on ALIVE->END transition)
  // formaer rtc_exiting_entry()
  // virtual RTC::ReturnCode_t onFinalize();

  // The startup action when ExecutionContext startup
  // former rtc_starting_entry()
  // virtual RTC::ReturnCode_t onStartup(RTC::UniqueId ec_id);

  // The shutdown action when ExecutionContext stop
  // former rtc_stopping_entry()
  // virtual RTC::ReturnCode_t onShutdown(RTC::UniqueId ec_id);

  // The activated action (Active state entry action)
  // former rtc_active_entry()
  virtual RTC::ReturnCode_t onActivated(RTC::UniqueId ec_id);

  // The deactivated action (Active state exit action)
  // former rtc_active_exit()
  virtual RTC::ReturnCode_t onDeactivated(RTC::UniqueId ec_id);

  // The execution action that is invoked periodically
  // former rtc_active_do()
  virtual RTC::ReturnCode_t onExecute(RTC::UniqueId ec_id);

  // The aborting action when main logic error occurred.
  // former rtc_aborting_entry()
  // virtual RTC::ReturnCode_t onAborting(RTC::UniqueId ec_id);

  // The error action in ERROR state
  // former rtc_error_do()
  // virtual RTC::ReturnCode_t onError(RTC::UniqueId ec_id);

  // The reset action that is invoked resetting
  // This is same but different the former rtc_init_entry()
  // virtual RTC::ReturnCode_t onReset(RTC::UniqueId ec_id);
  
  // The state update action that is invoked after onExecute() action
  // no corresponding operation exists in OpenRTm-aist-0.2.0
  // virtual RTC::ReturnCode_t onStateUpdate(RTC::UniqueId ec_id);

  // The action that is invoked when execution context's rate is changed
  // no corresponding operation exists in OpenRTm-aist-0.2.0
  // virtual RTC::ReturnCode_t onRateChanged(RTC::UniqueId ec_id);

  // Functions used by the services
  RTC::RangerGeometry get_geometry() const { return sensor_geom_; }
  void set_power(bool enable);
  void enable_intensity_data(bool enable);
  RTC::RangerConfig get_config() const { return sensor_config_; }
  void set_config(RTC::RangerConfig const& config);
  void request_scan();

 protected:
  // Configuration variable declaration
  // <rtc-template block="config_declare">
  
  // </rtc-template>

  // DataInPort declaration
  // <rtc-template block="inport_declare">

  // </rtc-template>

  // DataOutPort declaration
  // <rtc-template block="outport_declare">
  RangeData m_ranges_;
  OutPort<RangeData> m_ranges_Out;
  IntensityData m_intensities_;
  OutPort<IntensityData> m_intensities_Out;

  // </rtc-template>

  // CORBA Port declaration
  // <rtc-template block="corbaport_declare">
#ifdef __T_KERNEL__
  RTC::CorbaPort svc_port_;
#else
  RTC::CorbaPort m_RangerPort;
  RTC::CorbaPort m_HokuyoAistPort;
#endif

  // </rtc-template>

  // Service declaration
  // <rtc-template block="service_declare">
#ifdef __T_KERNEL__
  RTC_RangerSVC_impl m_svc_prov_;
  Hokuyo_Aist_HokuyoAistSVC_impl m_specialist_prov_;
#else
  RangerSVC_impl m_svc_prov_;
  HokuyoAistSVC_impl m_specialist_prov_;
#endif

  // Configurable settings
  std::string port_opts_;
  double start_angle_, end_angle_;
  unsigned int cluster_count_;
  bool enable_intns_;
  bool high_sens_;
  bool pull_mode_;
  bool new_data_mode_;
  time_t error_time_;
  double x_, y_, z_, roll_, pitch_, yaw_;
 
  hokuyo_aist::Sensor laser_;
  hokuyo_aist::ScanData scan_data_;
  RTC::RangerGeometry sensor_geom_;
  RTC::RangerConfig sensor_config_;

  coil::Mutex mutex_;
  double base_ang_res_;
  time_t last_error_time_;

  void open_laser();
  void close_laser();
  void reset_laser();
  void get_scan();
  void write_scan();
  
  // </rtc-template>

  // Consumer declaration
  // <rtc-template block="consumer_declare">

  // </rtc-template>

};


extern "C"
{
  DLL_EXPORT void rtc_hokuyoaistInit(RTC::Manager* manager);
};

#endif // RTC_HOKUYOAIST_H

