// -*-C++-*-
/*!
 * @file  rangerSVC_impl.h
 * @brief Service implementation header of ranger.idl
 *
 */

#include "rangerSkel.h"


#ifndef RANGERSVC_IMPL_H
#define RANGERSVC_IMPL_H

#ifdef __T_KERNEL__
class rtc_hokuyoaist;
#endif

/*
 * Example class implementing IDL interface RTC::Ranger
 */
class RTC_RangerSVC_impl
 : public virtual POA_RTC::Ranger,
   public virtual PortableServer::RefCountServantBase
{
 private:
   // Make sure all instances are built on the heap by making the
   // destructor non-public
   //virtual ~RTC_RangerSVC_impl();

 public:
   // standard constructor
   RTC_RangerSVC_impl();
   virtual ~RTC_RangerSVC_impl();

#ifdef __T_KERNEL__
	void setup(rtc_hokuyoaist* owner) { owner_ = owner; }
#else
	void setup(RTC_HokuyoAist* owner) { owner_ = owner; }
#endif

   // attributes and operations
   RTC::RangerGeometry* GetGeometry();
   void Power(::CORBA::Boolean enable);
   void EnableIntensities(::CORBA::Boolean enable);
#ifdef __T_KERNEL__
   RTC::RangerConfig * GetConfig();
#else
   RTC::RangerConfig GetConfig();
#endif
   void SetConfig(const RTC::RangerConfig& newConfig);

    private:
#ifdef __T_KERNEL__
	rtc_hokuyoaist* owner_;
#else
        RTC_HokuyoAist* owner_;
#endif
};



#endif // RANGERSVC_IMPL_H


