#include <QWidget>
#include <QDebug>
#include <QtGlobal>
#include <QEvent>
#include <QResizeEvent>
#include <QMoveEvent>
#include "widget_observer.h"

void
WidgetObserver::setObservable(QWidget* observable)
{
	observable_ = observable; 
	if (observable_) {
		observable_->installEventFilter(this);
		lastSize_ = observable_->size();
		lastPos_ = observable_->pos();
		qDebug() << "Pos: " << observable_->pos();
		qDebug() << "Size: " << observable_->size();		

	}
}
bool
WidgetObserver::eventFilter(QObject* target, QEvent* event)
{
	if (target == observable_) {
		lastSize_ = observable_->size();
		lastPos_ = observable_->pos();

		QEvent::Type type = event->type();
		if (type == QEvent::Resize) {
			QResizeEvent* re = static_cast<QResizeEvent*>(event);

			emit resized(observable_, re->oldSize(), re->size());

		} else if (type == QEvent::Move) {
			QMoveEvent* me = static_cast<QMoveEvent*>(event);

			emit moved(observable_, me->oldPos(), me->pos());

		} else if (type == QEvent::Close) {
			QCloseEvent* ce = static_cast<QCloseEvent*>(event);
			bool accepted = true;

			emit closing(observable_, accepted);

			if (!accepted) {
				ce->ignore();
				return true;
			}
		}
	}

	return target->eventFilter(target, event);
}
void
WidgetObserver::disconnect()
{
	if (observable_) {
		observable_->removeEventFilter(this);
	}
}


/*
 * Local Variables:
 * mode: c++
 * c-basic-offset: 4
 * tab-width: 4
 * indent-tabs-mode: t
 * End:
 *
 */
