/*!
 * @file shared_queue.h
 * @brief Queue for inter-thread communication
 * @author SAGAMI, Tsuyoshi <sagami@brains.co.jp>
 *
 */
#if !defined(SHARED_QUEUE_HEADER_)
#define      SHARED_QUEUE_HEADER_

#include <queue>
//#include <ace/OS.h>
//#include <ace/Task.h>
#include <ace/Synch.h>



template<typename T>
class SharedQueue {
public:
	SharedQueue() : not_empty_cond_(lock_) { }
#if 0
	// 注意：このメソッドから抜けた直後に他のスレッドが
	// queueを操作している可能性がある！
	bool empty() const
	{
		// 調べる:
		// return valueへのコピーと
		// auto オブジェクトのdestruction はどちらが先？
		//  
		// return q_.empty()と書いても同じ動作になる？
		// コピー後にdestructorが走ることが保証されなければならない
                
		ACE_Guard<ACE_Thread_Mutex> guard(lock_);
		bool result = q_.empty();

		return result;
	}
#endif
	void enqueue(const T& val)
	{
		ACE_Guard<ACE_Thread_Mutex> guard(lock_);
		q_.push(val);
		not_empty_cond_.signal();
	}

	// this blocks until not emtpy
	T dequeue()
	{
		ACE_Guard<ACE_Thread_Mutex> guard(lock_);
        
		while (q_.empty())
			not_empty_cond_.wait();

		T ret = q_.front();
		q_.pop();
		return ret;
	}
	bool try_dequeue(T& popped)
	{
		ACE_Guard<ACE_Thread_Mutex> guard(lock_);
		if (q_.empty())
			return false;
		popped = q_.front();
		q_.pop();
		return true;
	}
private:
	std::queue<T> q_;
	mutable ACE_Thread_Mutex lock_;
	mutable ACE_Condition<ACE_Thread_Mutex> not_empty_cond_;
};



#endif   /*!SHARED_QUEUE_HEADER_*/

/*
 * Local Variables:
 * mode: c++
 * c-basic-offset: 4
 * tab-width: 4
 * indent-tabs-mode: t
 * End:
 *
 */
