/*!
 * @file map_layer_table_view.h
 * @brief Widget for displaying Map Layers.
 * @author SAGAMI, Tsuyoshi <sagami@brains.co.jp>
 */

#ifndef   MAP_LAYER_TABLE_VIEW_HEADER_
#define   MAP_LAYER_TABLE_VIEW_HEADER_

#include <QTableView>
#include <QVector>

/*! @class MapLayerTableView
 *  @brief LayerView Widgetで使用されるviewクラス。
 *
 *  QTableViewにslotを追加。Mocファイルの生成のためヘッダだけ別とするが，
 *  LayerViewが内部で使用するため，method実装はlayer_view.cpp内に置く。
 *  必要が出た場合に分離する。
 */
class MapLayerTableView : public QTableView
{
	Q_OBJECT;
public:
	static const int MIN_WIDTH = 400; //!< widgetの最小幅
	static const int MIN_HEIGHT = 150;//!< widgetの最小高

	MapLayerTableView(QWidget* parent = 0); //!< widgetのコンストラクタ

	QVector<int> selectedLayerIndexes(); //!< 選択中のレイヤを保持するために使用
public slots:
	void moveUpSelected();  //!< slot:選択された行を上に遷移
	void moveDownSelected(); //!< slot:選択された行を下に遷移
private:
	//! moveSelectedRows用列挙型
	typedef enum { UP, DOWN } MoveDirection_t; 

	//! move{Up,Down}Selectedのための下請け関数。実作業を行う
	void moveSelectedRows(MoveDirection_t dir);

	//! 現在選択されている行のvisual indexをvectorで返す。
	QVector<int> selectedRowVisualIndexes();
};

#endif /*MAP_LAYER_TABLE_VIEW_HEADER_*/
/*
 * Local Variables:
 * mode: c++
 * c-basic-offset: 4
 * tab-width: 4
 * indent-tabs-mode: t
 * End:
 *
 */
