/*!
 * @file map_layer_delegate.cpp
 * @brief `Delegate' class of the MapLayerListModel
 * @author SAGAMI, Tsuyoshi <sagami@brains.co.jp>
 */

#include <QtGui>

#include <iostream>

#include "map_layer_delegate.h"

static const bool USE_SPINBOX_FOR_OPACITY = false;

using namespace std;

MapLayerDelegate::MapLayerDelegate(int col_visibility, int col_opacity, 
                                   int col_name,
                                   QObject* parent)
	: QItemDelegate(parent),
	  col_visibility_(col_visibility),
	  col_opacity_(col_opacity),
	  col_name_(col_name)
{
       
}
QWidget *
MapLayerDelegate::createEditor(QWidget *parent,
                               const QStyleOptionViewItem &option,
                               const QModelIndex &index) const
{
	if (index.column() == col_name_) {
		return 0;       // name is immutable
		//return QItemDelegate::createEditor(parent, option, index);
	} else if (index.column() == col_opacity_) {
		if (USE_SPINBOX_FOR_OPACITY) {
			QSpinBox* editor = new QSpinBox(parent);
			editor->setMinimum(0);
			editor->setMinimum(100);
			return editor;
		} else {
			return QItemDelegate::createEditor(parent, option, 
											   index);
		}
	} else if (index.column() == col_visibility_) {
		return QItemDelegate::createEditor(parent, option, index);
	} else {
		return QItemDelegate::createEditor(parent, option, index);
	}
}
void
MapLayerDelegate::setEditorData(QWidget *editor, const QModelIndex &index) const
{
	if (index.column() == col_name_) {
		QItemDelegate::setEditorData(editor, index);
	} else if (index.column() == col_opacity_) {
		if (USE_SPINBOX_FOR_OPACITY) {
			double opacity = index.model()->data(
				index, Qt::EditRole).toDouble(); 
			int percent = int(opacity);

			cout << "setEditorData: percent = " << percent << "\n"
				"               opacity = " << opacity << "\n";
			QSpinBox* spinBox = static_cast<QSpinBox*>(editor);
			spinBox->setValue(percent);
		} else {
			QItemDelegate::setEditorData(editor, index);
		}
	} else if (index.column() == col_visibility_) {
		QItemDelegate::setEditorData(editor, index);
	} else {
		QItemDelegate::setEditorData(editor, index);
	}
}
void 
MapLayerDelegate::setModelData(QWidget *editor, QAbstractItemModel *model,
                               const QModelIndex &index) const
{
	if (index.column() == col_name_) {
		QItemDelegate::setModelData(editor, model, index);
	} else if (index.column() == col_opacity_) {
		if (USE_SPINBOX_FOR_OPACITY) {
			QSpinBox *spinBox = static_cast<QSpinBox*>(editor);
			spinBox->interpretText();
			int value = spinBox->value();
			double opacity = value;
			cout << "setEditorData: value = " << value << "\n"
				"               opacity = " << opacity << "\n";

			model->setData(index, opacity, Qt::EditRole);
		} else {
			QItemDelegate::setModelData(editor, model, index);
		}
	} else if (index.column() == col_visibility_) {
		QItemDelegate::setModelData(editor, model, index);
	} else {
		QItemDelegate::setModelData(editor, model, index);
	}
}

void
MapLayerDelegate::updateEditorGeometry(QWidget *editor,
                                       const QStyleOptionViewItem &option, 
                                       const QModelIndex &index) const
{
	if (index.column() == col_name_) {
		QItemDelegate::updateEditorGeometry(editor, option, index);
	} else  if (index.column() == col_opacity_) {
		if (USE_SPINBOX_FOR_OPACITY) {
			editor->setGeometry(option.rect);
		} else {
			QItemDelegate::updateEditorGeometry(editor, option,
												index);
		}
	} else if (index.column() == col_visibility_) {
		QItemDelegate::updateEditorGeometry(editor, option, index);
	} else {
		QItemDelegate::updateEditorGeometry(editor, option, index);
	}
}
void
MapLayerDelegate::paint(QPainter* painter, 
                        const QStyleOptionViewItem& option,
                        const QModelIndex& index) const
{
	if (index.column() == col_name_) {
		QItemDelegate::paint(painter, option, index);
	} else if (index.column() == col_opacity_) {
		QStyleOptionViewItem myOpt = option;
		myOpt.displayAlignment = Qt::AlignHCenter|Qt::AlignVCenter;
		QItemDelegate::paint(painter, myOpt, index);
	} else if (index.column() == col_visibility_) {
		bool visible=index.model()->data(index, Qt::EditRole).toBool();
		QStyleOptionViewItem myOpt = option;
		myOpt.displayAlignment = Qt::AlignHCenter|Qt::AlignVCenter;
		drawDisplay(painter, myOpt, myOpt.rect,
					QString(visible ? "true" : "false"));
		drawFocus(painter, myOpt, myOpt.rect);
	} else {
		QItemDelegate::paint(painter, option, index);
	}
}
/*
 * Local Variables:
 * mode: c++
 * c-basic-offset: 4
 * tab-width: 4
 * indent-tabs-mode: t
 * End:
 *
 */
