/*!
 *  @file layer_archive.h
 *  @brief 
 *  @author SAGAMI, Tsuyoshi <sagami@brains.co.jp>
 */

#if !defined(LAYER_ARCHIVE_HEADER_)
#define      LAYER_ARCHIVE_HEADER_

#include <string>
#include <vector>
#include <boost/shared_ptr.hpp>


class MapLayer;

class LayerArchive
{
public:
	struct Data {
		std::string name;
		bool isVisible;
		float opacity;
		std::string xml;
	};

	typedef Data data_type;
	typedef std::vector<data_type> container_type;

	LayerArchive();

	void add(const MapLayer* layer);

	int saveToFile(const char* filename) const;
	int loadFromFile(const char* filename);


	const container_type& datas() const;

	struct Impl;
	boost::shared_ptr<Impl> impl_;
};


#endif   /*! LAYER_ARCHIVE_HEADER_ */
/*
 * Local Variables:
 * mode: c++
 * c-basic-offset: 4
 * tab-width: 4
 * indent-tabs-mode: t
 * End:
 *
 */
