#include <fstream>

#include "xml_serdes.h"
#include "gui_settings.h"

using namespace std;

namespace boost {
namespace serialization {

#define NVP(obj, member)  make_nvp(#member, obj.member)

/*! @brief @a WindowInfo用シリアライズ関数.
 *  @tparam Archive Boostのアーカイブクラス名
 *  @param[out] ar Archive Boostのアーカイブクラスのインスタンス
 *  @param[in] wi シリアライズ／デシリアライズされる@a WindowInfo
 *  @param[in] (未使用) バージョン
 */
template <class Archive>
void
serialize(Archive& ar, WindowInfo& wi, const unsigned int /* version */)
{
	ar & NVP(wi, pos_x);
	ar & NVP(wi, pos_y);
	ar & NVP(wi, width);
	ar & NVP(wi, height);
}

/*! @brief @a WindowInfo用シリアライズ関数.
 *  @tparam Archive Boostのアーカイブクラス名
 *  @param[out] ar Archive Boostのアーカイブクラスのインスタンス
 *  @param[in] gs シリアライズ／デシリアライズされる@a GuiSettings
 *  @param[in] (未使用) バージョン
 */
template <class Archive>
void
serialize(Archive& ar, GuiSettings& gs, const unsigned int /* version */)
{
	ar & NVP(gs, mapview);
	ar & NVP(gs, layerview);
}

#undef NVP

} /* namespace boost*/
} /* namespace serialization */


/* ---------------------------------------------------------------- *
 *  struct GuiSettings
 * ---------------------------------------------------------------- */
//! @def DEF_TYPE_ID(classname)class 名と同一のTYPE_IDを生成するためのマクロ
#define DEF_TYPE_ID(classname) const char classname::TYPE_ID[] = #classname
DEF_TYPE_ID(GuiSettings);		//!< TYPE_ID定義
#undef DEF_TYPE_ID

int
GuiSettings::readFromXml(std::istream& is)
{
	return XmlSerDes::readFromXmlSub(is, *this, TYPE_ID);
}
int
GuiSettings::writeToXml(std::ostream& os) const
{
	return XmlSerDes::writeToXmlSub(os, *this, TYPE_ID);
}
int
GuiSettings::readFromFile(const char* fname)
{
	ifstream ifs(fname);
	if (!ifs)
		return -1;
	return readFromXml(ifs);
}
int
GuiSettings::writeToFile(const char* fname) const
{
	ofstream ofs(fname);
	if (!ofs)
		return -1;
	return writeToXml(ofs);
}




/*
 * Local Variables:
 * mode: c++
 * c-basic-offset: 4
 * tab-width: 4
 * indent-tabs-mode: t
 * End:
 *
 */
