/*!
 * @file debug_utils.h
 * @brief utilities for debugging
 * @author SAGAMI, Tsuyoshi <sagami@brains.co.jp>
 */

#if !defined(DEBUG_UTILS_HEADER_)
#define      DEBUG_UTILS_HEADER_

#include <iostream>

/*!
 * @class Tracer
 * @brief Scoped tracer for observing an entry to/exit from a function.
 */
class Tracer {
public:
	/*!
	 * @brief Constructor. stores and emit given message(usualy a
	 *        place in a source).
	 * 
	 * 
	 * @param[in] mesg message to be displayed.
	 * @param[in] ost stream used for displaying the message.
	 */
	Tracer(const char* mesg, std::ostream& ost);

	/*!
	 *  @brief Destructor. emits a dying message.
	 */
	virtual ~Tracer() ;

private:
	const char* mesg_;			//!< message strings to be displayed
	std::ostream& ost_;			//!< output stream for message
};

/*!
 * @def FUNC_TRACE
 * macro for tracing function entry/exit using GCC's extention 
 * to show the function name if available. 
 *
 */
#if defined(__GNUC__)
#    define FUNC_TRACE	Tracer __t(__PRETTY_FUNCTION__, std::cout) 
#else
#    define XSTR___(s) STR___(s)
#    define STR___(s) #s
#    define FUNC_TRACE	Tracer __t(__FILE__ ":" XSTR___(__LINE__), std::cout) 
#endif

#endif  /*!  DEBUG_UTILS_HEADER_*/
/*
 * Local Variables:
 * mode: c++
 * c-basic-offset: 4
 * tab-width: 4
 * indent-tabs-mode: t
 * End:
 *
 */
