#include <cmath>
#include <iostream>
#include <limits>
#include "GridMap.h"
#include "RgisOperator_simpleStub.h"
#include "cur_pos.h"
#include "merge_grid.h"
#include "debug_utils.h"
#include "navigation_data.h"

using namespace std;
using namespace RGIS;
using namespace RGIS::Geo;

namespace /* unnamed */ {
      
class CoordinateTransform {
public:
	CoordinateTransform(const RGIS::Geo::GridInfoC& gi)
		: numCellsW_(gi.numCellsW),
		  numCellsH_(gi.numCellsH),
		  cellWidth_(gi.cellWidth),
		  cellHeight_(gi.cellHeight),
		  position_(gi.position) 
	{ }

	PntC imageToReal(double imgx, double imgy) const;

private:
	int numCellsW_;
	int numCellsH_;
	double cellWidth_;
	double cellHeight_;
	PntC position_;

};

// We assume the compiler will do the `Named RVO'. (Current GCC does.)
PntC
CoordinateTransform::imageToReal(double imgx, double imgy) const
{
        double x_topLeft = position_.x;
        double y_topLeft = position_.y;

		PntC p;
		p.x = x_topLeft + ((imgx + 0.5) * cellWidth_);
		p.y = y_topLeft - ((imgy + 0.5) * cellHeight_);
        return p;
}
double
find_fill_value(const RGIS::Geo::GridC& potential)
{
	const GridInfoC& info = potential.info; // just for readability
	if (info.useNoData)
		return info.noDataVal;

	const size_t n_cells = info.numCellsW * info.numCellsH;
	const double* begin = (const double*)(potential.data.NP_data());
	const double* end = begin + n_cells;

	return *max_element(begin, end);
}



void
do_merge_self(RGIS::Geo::GridC& potential, const GridMap& probs, const CurPos& pos, double obs_th)
{
	FUNC_TRACE;

	// probs.coord == self;
	const double c_th = cos(pos.theta);
	const double s_th = sin(pos.theta);
        // bottom-left of add in robot coord.
	const double xr_0 = probs.area_x0;
	const double yr_0 = probs.area_y0;
	const double xr_1 = probs.area_x1;
	const double yr_1 = probs.area_y1;

	cout << "(x0, y0) = (" << xr_0 << ", " << yr_0 << ")\n";
	cout << "(x1, y1) = (" << xr_1 << ", " << yr_1 << ")\n";

	const int sheight = probs.sizeY();
	const int swidth  = probs.sizeX();
	const int dheight = potential.info.numCellsH;
	const int dwidth  = potential.info.numCellsW;

	const double xscale = double(swidth) / (xr_1 - xr_0);
	const double yscale = double(sheight) / (yr_1 - yr_0);
	
	const float* sp = &(probs.map[0]);
	double*      dp = (double*)(potential.data.NP_data());

	const double fill_value = find_fill_value(potential);

	CoordinateTransform ct(potential.info);
	const PntC& p = pos.pos; // just for readbility
	
	// very slow and redundunt loop.
	//  1. x, y need not be searched in their full ranges
	//  2. CSE is probably possible .
	for (int y = 0; y < dheight; ++y) {
		for (int x = 0; x < dwidth; ++x) {

			PntC xg = ct.imageToReal(x, y);

			// xr, yr: robot coordinate
			double xr = +c_th * (xg.x - p.x) + s_th * (xg.y - p.y);
			double yr = -s_th * (xg.x - p.x) + c_th * (xg.y - p.y);
                        
			// robot coordinate -> 2d index
			int i = int(xscale * (xr   - xr_0));
			int j = int(yscale * (yr_1 - yr));

			if (0 <= i && i < swidth && 0 <= j && j < sheight) {
				if (sp[j*swidth + i] > obs_th)
					dp[x] = fill_value;
			}
		}
		dp += dwidth;
	}
}
void
do_merge_jgd9(RGIS::Geo::GridC& potential, const GridMap& probs, const CurPos& pos, double obs_th)
{
	cout << "Unsupported coordinate for probability map: "
		 << probs.coordinate << "\n";
}

} /* unnamed namespace */


void
do_merge(RGIS::Geo::GridC& potential, const GridMap& probs, const CurPos& pos, double obs_th)
{
	if (potential.info.numCellsW * potential.info.numCellsH == 0) {
		cout << "empty grid. nothing to do\n";
		return;
	} 

	if (probs.coordinate == "self") {
		return do_merge_self(potential, probs, pos, obs_th);
	} else if (probs.coordinate == NavData::COORD_JGD9) {
		return do_merge_jgd9(potential, probs, pos, obs_th);
	} else {
		cout << __PRETTY_FUNCTION__ << ": "
			 << "Unsupported Coordinate for probability map:  " 
			 << probs.coordinate << "\n";
	}
}



/*
 * Local Variables:
 * mode: c++
 * c-basic-offset: 4
 * tab-width: 4
 * indent-tabs-mode: t
 * End:
 *
 */
