/*!
 * @file debug_utils.cpp
 * @brief utilities for debugging
 * @author SAGAMI, Tsuyoshi <sagami@brains.co.jp>
 */
#include <ostream>

#include "RgisOperator_simpleStub.h"
#include "debug_utils.h"

using namespace std;
using RGIS::PntC;
using RGIS::BoxC;
using RGIS::Geo::GridInfoC;
using RGIS::Geo::GridInfoC;
using RGIS::Geo::GridC_var;
using RGIS::Geo::LineStringC_var;


Tracer::Tracer(const char* mesg, std::ostream& ost) 
	: mesg_(mesg), ost_(ost)
{
	ost_ << ">>>	 " << mesg_ << std::endl; 
}
Tracer::~Tracer() 
{
	ost_ << "<<<	 " << mesg_ << "\n" << std::endl; 
}

/*
 * Local Variables:
 * mode: c++
 * c-basic-offset: 4
 * tab-width: 4
 * indent-tabs-mode: t
 * End:
 *
 */
