/*!
 * @file cur_pos.h
 * @brief Structure to represent current position
 * @author SAGAMI, Tsuyoshi <sagami@brains.co.jp>
 *
 * $Id:$
 *
 */

#if !defined(CUR_POS_HEADER_)
#define      CUR_POS_HEADER_

#include "RgisOperator_simpleStub.h"

/*!
 * @class CurPos
 * @brief 現在位置情報を格納するための構造体.
 */
struct CurPos {
	//! デフォルトコンストラクタ
	CurPos() : pos(), theta(0.0), reset(false) { }

	//! 位置と角度を指定するコンストラクタ
	CurPos(const RGIS::PntC& p, float th, bool reset=false)
		: pos(p), theta(th), reset(reset) { }

	RGIS::PntC pos;				//!< 位置情報[m]
	float theta;				//!< 角度情報[rad]
	bool reset;					//!< この情報でリセットするか?
};


#endif    /*!CUR_POS_HEADER_*/
/*
 * Local Variables:
 * mode: c++
 * c-basic-offset: 4
 * tab-width: 4
 * indent-tabs-mode: t
 * End:
 *
 */
