// -*- C++ -*-
/*!
 * @file  GlobalNavigationRTC.h 
 * @brief RT component class for Global Navigation 
 */
#ifndef GLOBALNAVIGATION_RTC_H
#define GLOBALNAVIGATION_RTC_H

#include <queue>

#include <rtm/idl/BasicDataTypeSkel.h>
#include <rtm/Manager.h>
#include <rtm/DataFlowComponentBase.h>
#include <rtm/CorbaPort.h>
#include <rtm/DataInPort.h>
#include <rtm/DataOutPort.h>
#include <vector>
#include <boost/shared_ptr.hpp>

// Service implementation headers
// <rtc-template block="service_impl_h">

// </rtc-template>

// Service Consumer stub headers
// <rtc-template block="consumer_stub_h">
#include "RgisOperator_simpleStub.h"

// </rtc-template>

using namespace RTC;

class GNav;
class ConfigData;

class GlobalNavigationRTC  : public RTC::DataFlowComponentBase
{
public:
	/*! コンポーネントのコンストラクタ.
	 *  @param[in] manager コンポーネントの管理を行うManagerへの参照 
	 */
	GlobalNavigationRTC(RTC::Manager* manager);

	virtual ~GlobalNavigationRTC(); //!< デストラクタ

	//! 初期化時にコールされる.
	virtual RTC::ReturnCode_t onInitialize();
	//! アクティベート時にコールされる.
	virtual RTC::ReturnCode_t onActivated(RTC::UniqueId ec_id);
	//! ディアクティベート時にコールされる.
	virtual RTC::ReturnCode_t onDeactivated(RTC::UniqueId ec_id);
	//! アクティベート後，定期的にコールされる.
	virtual RTC::ReturnCode_t onExecute(RTC::UniqueId ec_id);
protected:

	//! 入力ポートにバインドされるTimedStringを格納するvector(shared_ptr使用)
	std::vector<boost::shared_ptr<TimedString> > m_ins;
	//! 入力ポートを格納するvector(shared_ptr使用)
	std::vector<boost::shared_ptr<InPort<TimedString> > > m_inIns;

	TimedString m_out;			//!< 出力ポートにバインドされるTimedString
	OutPort<TimedString, NullBuffer> m_outOut; //!< 出力ポート 

	RTC::CorbaPort m_mapServicePort; //!< RGISのMapServiceを受けるポート
	RTC::CorbaPort m_routeServicePort; //!< RGISのRouteServiceを受けるポート

	//! RGISのMapServiceを受ける，サービス消費者(Service Consumer)
	RTC::CorbaConsumer<RGIS::RTComp::MapService> m_mapService;
	//! RGISのRouteServiceを受ける，サービス消費者(Service Consumer)
	RTC::CorbaConsumer<RGIS::RTComp::RouteService> m_routeService;

	std::string filename;		//!< 設定ファイルの名称
	boost::shared_ptr<GNav> gnav_; //!< バックエンドクラスへの参照
	boost::shared_ptr<ConfigData> config_; //!< 設定ファイル保持クラスへの参照

private:
	void flushQueue();			//!< 出力queueをポートへフラッシュする

	/*! オブジェクトを出力ポートにXMLとして書く.
	 *  @param[in] s 出力されるオブジェクト
	 *  @param[in] tag タグ名
	 */
	template <class Serializable> bool writeToPort(const Serializable& s, 
												   const std::string& tag);
	std::queue<std::string> resultq_; //!< 出力を格納するqueue
	bool initcmd_sent_; //!< フラグ。目的地，現在地の初期値が送信されたかどうか
};


extern "C"
{
	void GlobalNavigationRTCInit(RTC::Manager* manager);
};

#endif // GLOBALNAVIGATION_RTC_H

/*
 * Local Variables:
 * mode: c++
 * c-basic-offset: 4
 * tab-width: 4
 * indent-tabs-mode: t
 * End:
 *
 */
