////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////
//@file  rtc_control.h
//@brief RTC制御関数ヘッダ．
//$Date$ 2009/12/5
//@author eno 
//@mail:enoreplies@gmail.com
//@WebPage:http://www15.atpages.jp/~technotes/wiki/
//$Id$ 
/////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////
/*
rtc-controller

The MIT License

Copyright (c) 2009 eno<enoreplies@gmail.com>

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
*/
/////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////

#include <stdio.h>
#include <rtm/CorbaNaming.h>
#include <rtm/RTObject.h>
#include <rtm/CorbaConsumer.h>
#include <iostream>
#include <cctype>
#include <string>
#include <fstream>
#include <vector>
using namespace std;

/////////////////////////////////////////////////////////////////////////////////////////////
//最大RTコンポーネント数，100個以下
#define COMPMAXNUM 100	

/////////////////////////////////////////////////////////////////////////////////////////////
//○エラー判定Signalの定義
#define SIGNAL_ERROR -1
#define SIGNAL_TRUE 0

/////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////
//○文字列制御関数一覧
int str_conv_int(string str);
//int name_check(vector<string> &namelist,string name);
int rtc_number_to_name(string namelist[],int namelist_num,int num,string &name);
int port_number_to_name(string namelist[],int namelist_num,int num,string &name);
int name_to_number(string namelist[],int namelist_num,string name,int &num);
void name_show(string namelist[],int namelist_num);

/////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////
//○RTC制御関数一覧
void ListRecursive(CosNaming::NamingContext_ptr context,vector<string> &rtclist,string &name);
int rtc_namecheck(string rtc_name,string complist[],int comp_num);
int ConnectionList(RTC::CorbaNaming &naming,string rtc_name,string comp_buff[],string port_buff[],int &con_num,string con_id[]);
int rtc_disconnect(RTC::CorbaNaming &naming,string rtc_name,int port_num);
int rtc_disconnect(RTC::CorbaNaming &naming,string rtc_name);
int rtc_destoryall(RTC::CorbaNaming &naming);
int rtc_connect(RTC::CorbaNaming *in_naming,string pout_name,
				int pout_num,RTC::CorbaNaming *out_naming,string pin_name,int pin_num,string subs_type="flush",string period="");
int rtc_connect(RTC::CorbaNaming &naming,string pout_name,int pout_num,string pin_name,int pin_num);
int rtc_portname_resolution(RTC::CorbaNaming &naming,string rtc_name,string port_name);
int rtc_portshow(RTC::CorbaNaming &naming,string rtc_name);
int rtc_list(RTC::CorbaNaming &naming,string *complist,int &comp_num);
int rtc_list(RTC::CorbaNaming &naming);
int rtc_active(RTC::CorbaNaming &naming,string rtc_name);
int rtc_deactive(RTC::CorbaNaming &naming,string rtc_name);
int rtc_reset(RTC::CorbaNaming &naming,string rtc_name);
int rtc_config_set(RTC::CorbaNaming &naming,string in_name,string key,string value,string confset_name);
int rtc_new_config_set(RTC::CorbaNaming &naming,string in_name,string key,string value,string confset_name);
int rtc_config_set(RTC::CorbaNaming &naming,string in_name,string key,string value);
int rtc_port_namelist(RTC::CorbaNaming &naming,string rtc_name);
int rtc_all_show(RTC::CorbaNaming &naming);
int rtc_all_active(RTC::CorbaNaming &naming);
int rtc_all_deactive(RTC::CorbaNaming &naming);
int rtc_all_disconnect(RTC::CorbaNaming &naming);
int rtc_config_get(RTC::CorbaNaming &naming,string in_name,string confset_name);
int rtc_state(RTC::CorbaNaming &naming,string rtc_name);
int rtc_all_get_rate(RTC::CorbaNaming &naming);
int rtc_set_rate(RTC::CorbaNaming &naming,string rtc_name,double helz);
int rtc_get_rate(RTC::CorbaNaming &naming,string rtc_name);
int rtc_connect_info(RTC::CorbaNaming &naming,string rtc_name);
int rtc_comp_info(RTC::CorbaNaming &naming,string rtc_name);
int rtc_port_info(RTC::CorbaNaming &naming,string rtc_name);
int rtc_get_rtclist(RTC::CorbaNaming &naming,vector<string> &rtclist);
int rtc_get_portlist(RTC::CorbaNaming &naming,string rtc_name,vector<string> &portnames);
int rtc_connect_save(RTC::CorbaNaming &naming,string ipsdress,string fname);
int rtc_connect_load(RTC::CorbaNaming &naming,string fname);


