<?php
	// common RSS reader classes
	
	class NewsOptions {
		var $version = '2.9.4';
		var $charset = 'UTF-8';//*necessary
		var $sourcecharset = 'auto';// when you got garbles
		var $timeout = 2;//seconds
		var $cssclass_tag = 'div';
		var $cssclasslabel_tag = 'div';
		var $cssclassitem_tag = 'div';
		var $cssclassby_tag = 'div';
		var $cssclasserror_tag = 'div';
		var $cssclass = 'news';
		var $cssclassitem = 'news-list';
		var $cssclasslabel = 'news-label';
		var $cssclassby = 'news-poweredby';
		var $cssclasserror = 'news-error';
		var $labelheight = 768;//*vertially no limit
		var $labelwidth = 1024;//* --
		var $maxitem;//default: unlimit 
		var $descriptionlength = 200;//byte
		var $tbp = FALSE;// option for track back people
		var $bpll = FALSE;// option for BlogPeople link list
		var $popup = FALSE;// for popdescription
		var $blockimagelabel = FALSE;//suppress title images
		var $labelsubstitute;// MAY be used with ($blockimagelabel=TRUE)if you prefer your own title text to the original ones
		var $cachedir = './RSS_cache/';
		var $suppresserror = FALSE;//mainly network error outputs
		var $backwardtime = FALSE;// change the way of showing updated time
		var $sort = FALSE;// modify the appearance for latest item first
		var $striptag = FALSE;// strip tag
		var $excludetag = "";// exclude these tags if the striptag option  is enabled
		var $untag = FALSE;// display the powered-by line by default
		var $anchortagoption = 'rel="nofollow"';// stop search engines indexing links by default. DO NOT change this to EMPTY or you get sum of broken links. leave one space at least if you change.
		
		function NewsOptions ( $init ) {
			// hash table must be given
			foreach ( $init as $key => $val ) {
				$this->$key = $val;
			}
		}
	}

	class News {
		var $channel;
		var $options;
		
		function News( &$init/*!REFERENTIAL!*/ ) {
			// assuming the object of NewsOptions given
			$this->options = &$init;
			register_shutdown_function( array(&$this,"shutdown") );
		}
	
		function readRSS( $filename ) {
			$filecontent = "";
			if ( !($fh = @fopen( $filename, 'r' )) ) {
				if ( !$this->options->suppresserror )
					printf("<%s class=\"%s\">URL: %s\n.network trouble! skipping...\n</%s>", $cssclasserror_tag, $cssclasserror, $filename, $cssclasserror_tag);
				return FALSE;
			}
			if ( $this->options->timeout ) {
				stream_set_timeout( $fh, $this->options->timeout );
			}
			while ( !feof($fh) ) {
				$tmp = fread( $fh, 4096 );
				if ( $tmp ) {
					$filecontent .= $tmp;
				} else {
					// when run out of the time
					if ( !$this->options->suppresserror )
						printf("<%s class=\"%s\">URL: %s\n.laggy network! skipping...\n</%s>", $cssclasserror_tag, $cssclasserror, $filename, $cssclasserror_tag);
					return FALSE;
				}
			}
			fclose( $fh );
			// convert character encoding at a time
			mb_convert_variables( $this->options->charset, $this->options->sourcecharset, $filecontent );
			// xml
			$xmlparser = xml_parser_create();
			xml_parser_set_option( $xmlparser,XML_OPTION_CASE_FOLDING,0 );
			xml_parser_set_option( $xmlparser,XML_OPTION_SKIP_WHITE,1 );
			xml_parse_into_struct( $xmlparser, $filecontent, $values, $tags );
			xml_parser_free( $xmlparser );
			// create Channel object first
			$objs = array();
			if ( $tags['channel'] ) {
				$objs = $this->createObject( $tags['channel'], $values, 'Channel' );
			} else {
				/*atom extension*/
				$objs = $this->createObject( $tags['feed'], $values, 'Channel' );
				$objs[0]->feed = 'atom';
 			}
			$this->channel = $objs[0];
			// trace for each other tag
			foreach ( $tags as $tkey=>$tval ) {
				switch( $tkey ){
					// these statements should be called just one time
					case 'image':
						$objs = $this->createObject( $tval, $values, 'Image' );
						$this->channel->addImage( $objs[0] );
						break;
					case 'entry':/*atom*/
					case 'item':
						$this->channel->addItem( $this->createObject( $tval, $values, 'Item' ) );
						break;
				}
			}
			return TRUE;
		}
		// create and return Objects
		function createObject( $tval, &$values, $classname ) {
			$items = array();
			$currentlevel = $values[$tval[0]]['level'];
			// loop for index tags which locate the array-index of values.
			for ( $i = 0; $i < count($tval); $i+=2 ) {
				$item = array();
				$item_attr = array();
				// loop for extracting each value of the tag
				for ( $ii = $tval[$i]+1; $ii < $tval[$i+1]; $ii++ ) {
					//we need only one deeper level of data
					if ( $currentlevel +1 == $values[$ii]['level'] ) {
						// we only use '<link rel="alternate"...' as a link value whenever it reads an Atom feed.
						if ( ($values[$tval[0]]['tag'] == 'feed'||$values[$tval[0]]['tag'] == 'entry') && $values[$ii]['tag'] == 'link' && $values[$ii]['attributes']['rel'] != 'alternate' ) {
							;//avoid storing if matches
						} else {
							$item[$values[$ii]['tag']] = htmlspecialchars($values[$ii]['value'], ENT_QUOTES, $this->options->charset);
							$item_attr[$values[$ii]['tag']] = $values[$ii]['attributes'];
						}
					}
				}
				// create classes detecting the class's name automatically.
				$items[] = new $classname( $item, $item_attr, $this->options );
			}
			// for TrackBackPeople
			if ( $this->options->tbp && $classname == 'Image' && $items[0] ) {
				//currently 'title' property of Image isn't used
				$data['width'] = '106';
				$data['height'] = '24';
				$data['url'] = $values[$tval[0]]['attributes']['rdf:resource'];
				unset($items);
				$items[] = new $classname( $data, array(), $this->options );
			}
			return $items;
		}
		
		function show() {
			if ( $this->channel && count(get_class_methods($this->channel))) {
				$this->channel->show();
			} else if ( !$this->options->suppresserror ) {
				print 'RSS data is empty somehow';
			}
			// discarding the channel variable means you can't print the same list again
			unset( $channel );
			// change labelsubstitute to the default value
			$this->options->labelsubstitute = "";
		}
		function createCache( $filename ) {
			if ( !$this->readRSS( $filename ) || !count(get_class_methods($this->channel)) )
				return FALSE;
			if ( !is_dir($this->options->cachedir) ) {
				mkdir( $this->options->cachedir ) or die('cannot create the cache directry');
			}
			$cachepath = substr($this->options->cachedir.urlencode($filename),0,250);
			$fh = fopen( $cachepath, 'w' ) or die('cannot open the cache file');
			flock( $fh, LOCK_EX ) or die('cannot lock the cache file');
			fputs( $fh, serialize($this->channel) );
			flock( $fh, LOCK_UN );
			fclose( $fh );
			$this->options->untag = TRUE;
			return TRUE;
		}
		function readCache( $filename ) {
			$result = FALSE;
			$cachepath = substr($this->options->cachedir.urlencode($filename),0,250);
			$fh = @fopen( $cachepath, 'r' );
			if ( $fh ) {
				@flock( $fh, LOCK_SH );
				if ( $bytes = @fgets( $fh ) ) {
					$this->channel = unserialize( $bytes );
					if ( count($this->channel->item) );
						$result = TRUE;
				}
				@flock( $fh, LOCK_UN );
				@fclose( $fh );
			}
			if ( !$result ) {
				// fail soft: don't use cache if some error occured
				$this->readRSS( $filename );
			}
			return $result;
		}
		function shutdown() {
			$this->poweredby();
		}
		function poweredby() {
			static $flag = 0;
			if ( !$flag && !$this->options->untag ) {
				printf( '<%s class="%s"><a href="http://sourceforge.jp/projects/rsswebreader/">RSS Web Reader</a> (Ver.%s)</%s>', $this->options->cssclassby_tag, $this->options->cssclassby, $this->options->version, $this->options->cssclassby_tag);
				$flag++;
			}
		}
	}
	
	class Channel extends Element {
		var $feed = 'rss';//for atom
		var $image;
		var $item = array();

		function addItem( $item ) {
			$this->item = $item;
		}
		function addImage( $image ) {
			if ( $this->options->tbp ) {
				// for TrackBackPeople
				$image->data['link'] = $this->data['link'];
			}
			$this->image = $image;
		}
		function show() {
			printf( '<%s class="%s">', $this->options->cssclass_tag, $this->options->cssclass );
			printf( '<%s class="%s">', $this->options->cssclasslabel_tag, $this->options->cssclasslabel );
			// use Title Image
			if ( $this->image && !$this->options->blockimagelabel ) {
				$this->image->show( $this->getTitle() );
			// use Title Text
			} else {
				$link = $this->getLink();
				$description = $this->getSummary();
				printf( '<a %s href="%s" title="%s">%s</a>', 
					$this->options->anchortagoption, "$link", $description, ($this->options->labelsubstitute)?$this->options->labelsubstitute:$this->getTitle() );
			}
			printf( '</%s>', $this->options->cssclasslabel_tag );// -label
			// a section of printing items
			if ( $this->options->sort ) {
				usort( $this->item, 'compareDate' );
			}
			$itemrepeat = ($this->options->maxitem)?min(count($this->item),$this->options->maxitem): count($this->item);
			for ( $i=0; $i < $itemrepeat; $i++ ) {
				// do not show until the time comes
				if ( time() - $this->item[$i]->getTimestamp() >= 0 ) {
					$this->item[$i]->show();
				}
			}
			printf( '</%s>', $this->options->cssclass_tag );// -
		}
	}

	class Image extends Element {
		function show( $title ) {
			/*atom*/
			$src = ($this->data['url'])?$this->data['url']:$this->data['uri'];
			$link = $this->getLink();
			/*----*/
			$width = $this->data['width'];
			$height = $this->data['height'];
			$this->fixDimension( $width, $height );
			printf( '<a %s href="%s" title="%s"><img src="%s" alt="%s" width="%s" height="%s" /></a>'."\n", 
				$this->options->anchortagoption, "$link", $title, "$src", $title, "$width", "$height" );
		}
		function fixDimension( &$width, &$height ) {
			//debug printf('<!-- %s/%s=%s,%s/%s=%s -->',$width,$this->options->labelwidth,$width / $this->options->labelwidth,$height,$this->options->labelheight,$height / $this->options->labelheight);
			// everything's ok
			if ( $width <= $this->options->labelwidth && $height <= $this->options->labelheight ) {
				;//nothign happens
			// either's exeeded
			} else if ( ($width / $this->options->labelwidth) > ($height / $this->options->labelheight) ) {
				// width length is relatively more exceeded than height
				$height = round( $this->options->labelwidth / $width * $height );
				$width = $this->options->labelwidth;
			} else {
				// height
				$width = round( $this->options->labelheight / $height * $width );
				$height = $this->options->labelheight;
			}
		}
	}

	class Item extends Element {
		function show() {
			$id = rand();
			printf( '<%s id="item%s" class="%s">', $this->options->cssclassitem_tag, $id, $this->options->cssclassitem );
			$date = $this->getDate( "[n/j G:i] ", $this->options->backwardtime );
			$link = $this->getLink();
			$description = $this->getSummary();
			
			// for popup
			if ( $this->options->popup ) {
				printf( '<a %s id="item_a%s" href="%s" title="%s" onmouseover="popLayer(\'item_a%s\')" onmouseout="hideLayer()">%s</a>', 
				$this->options->anchortagoption, $id, "$link", $date.'&lt;br /&gt;'.$description, $id, $this->sanitizePossibleTags($this->getTitle()) );
			// ordinary
			} else {
				printf( '<a %s href="%s" title="%s">%s</a>',
					$this->options->anchortagoption, "$link", $date.$description, $this->sanitizePossibleTags($this->getTitle()) ); 
			}
			printf( '</%s>', $this->options->cssclassitem_tag );
		}
	}

	class Element {
		var $data = array();
		var $attr = array();/*hash + array*/
		var $options;

		function Element( $init, $init_attr, &$options/*!REFERENTIAL!*/ ) {
			$this->options = &$options;
			foreach ( $init as $k => $v ) {
				$this->data[$k] = $v;
			}
			foreach ( $init_attr as $k => $v ) {
				$this->attr[$k] = $v;
			}
		}
		function trimString( $str ) {
			if ( $this->options->popup ) {
				return $str;
			} else {
				return mb_convert_kana( mb_strimwidth( $str, 0, $this->options->descriptionlength, '...', $this->options->charset ), 'aKs', $this->options->charset );
			}
		}
		// mostly for Google blog search
		function sanitizePossibleTags( $str ) {
			return str_replace(
				array('&lt;b&gt;','&lt;B&gt;','&lt;/b&gt;','&lt;/B&gt;'),
				'',
				$str
			);
		}
		function getTitle() {
			if ($this->options->striptag) {
				return $this->trimString( htmlspecialchars(strip_tags( $this->unhtmlspecialchars($this->data['title']), $this->options->excludetag )) );
			} else {
				return $this->trimString( $this->data['title'] );
			}
		}
		function getLink() {
			$link = ($this->data['link'])?$this->data['link']:$this->attr['link']['href'];
			if ($this->options->striptag) {
				$link = htmlspecialchars( strip_tags( $this->unhtmlspecialchars($link), $this->options->excludetag ) );
			}
			return $link;
		}
		function getSummary() {
			if ( $this->data['subtitle'] ) 
				$summary = $this->data['subtitle'];
			else if ( $this->data['tagline'] )
				$summary = $this->data['tagline'];
			else if ( $this->data['description'] )
				$summary = $this->data['description'];
			else if ( $this->data['summary'] )
				$summary = $this->data['summary'];
			else
				$summary = "";
			if ($this->options->striptag) {
				$summary = htmlspecialchars( strip_tags( $this->unhtmlspecialchars($summary), $this->options->excludetag ) );
			}
			return $this->trimString( $summary );
		}
		function getTimestamp() {
			$timestamp;
			$datetime;
			if ( $this->data['dc:date'] ) {
				$datetime = $this->data['dc:date'];
			} else if ( $this->data['pubDate'] ) {
				$datetime = $this->data['pubDate'];
			/*atom*/
			} else if ( $this->data['modified'] ) {
				$datetime = $this->data['modified'];
			} else if ( $this->data['updated'] ) {
				$datetime = $this->data['updated'];
			/*----*/
			} else {
				return;
			}
			// ordinary date format
			if ( strtotime( $datetime ) != -1 ) {
				$timestamp = strtotime( $datetime );
			} else {// other date format
				// Year
		    if(preg_match("/^(\d{4})$/", $datetime, $val)) {
		        $year = $val[1];
		
		    // Year and month
    		} elseif(preg_match("/^([0-9]{4})-(0[1-9]|1[0-2])$/", $datetime, $val)) {
		        $year = $val[1];
		        $month = $val[2];
		
		    // Complete date
    		} elseif(preg_match("/^([0-9]{4})-(0[1-9]|1[0-2])-(0[1-9]|[1-2][0-9]|3[0-1])$/", $datetime, $val)) {
		        $year = $val[1];
		        $month = $val[2];
		        $day = $val[3];
		
		    // Complete date plus hours and minutes
    		} elseif(preg_match("/^([0-9]{4})-(0[1-9]|1[0-2])-(0[1-9]|[1-2][0-9]|3[0-1])T([0-5][0-9]):([0-5][0-9])(Z|(\+|-)[0-5][0-9]:[0-5][0-9])$/", $datetime, $val)) {
		        $year = $val[1];
		        $month = $val[2];
		        $day = $val[3];
		        $hour = $val[4];
		        $minute = $val[5];
		        $timezone = $val[6];
		
		    // Complete date plus hours, minutes and seconds
    		} elseif(preg_match("/^([0-9]{4})-(0[1-9]|1[0-2])-(0[1-9]|[1-2][0-9]|3[0-1])T([0-5][0-9]):([0-5][0-9]):([0-5][0-9])(Z|(\+|-)[0-5][0-9]:[0-5][0-9])$/", $datetime, $val)) {
		        $year = $val[1];
		        $month = $val[2];
		        $day = $val[3];
		        $hour = $val[4];
		        $minute = $val[5];
		        $second = $val[6];
		        $timezone = $val[7];
		
    		// Complete date plus hours, minutes, seconds and a decimal fraction of a second
    		} elseif(preg_match("/^([0-9]{4})-(0[1-9]|1[0-2])-(0[1-9]|[1-2][0-9]|3[0-1])T([0-5][0-9]):([0-5][0-9]):([0-5][0-9]).([0-9]+)(Z|(\+|-)[0-5][0-9]:[0-5][0-9])$/", $datetime, $val)) {
		        $year = $val[1];
		        $month = $val[2];
		        $day = $val[3];
		        $hour = $val[4];
		        $minute = $val[5];
		        $second = $val[6];
		        $fraction = $val[7];
		        $timezone = $val[8];
		
		    // Not W3C-DTF
		    } else {
		        return;
		    }
		
		    // Offset of Timezone for gmmktime()
		    if($timezone != "Z") {
		        $offset_sign = substr($timezone, 0, 1);
		        $offset_hour = substr($timezone, 1, 2);
		        $offset_minute = substr($timezone, 4, 2);
		    }
    		$timestamp = gmmktime($hour - ($offset_sign . $offset_hour), $minute - ($offset_sign . $offset_minute), $second, $month, $day, $year);
			}
			return $timestamp;
		}
		function getDate( $format, $isbackward ) {
			$timestamp = $this->getTimestamp();
			
			if ( !$timestamp ) {
				return "";
			}
			else if ( $isbackward ) {
				$diff = time() - $timestamp;
				$suffix;
				if ( $diff < 60 ) {
					$suffix = ($diff == 1)?'second':'seconds';
				} else if ( $diff < 3600/*<1hour*/ ) {
					$diff = floor( $diff / 60 );
					$suffix = ($diff == 1)?'minute':'minutes';
				} else if ( $diff < 172800/*<2day*/ ) {
					$diff = floor( $diff / 3600 );
					$suffix = ($diff == 1)?'hour':'hours';
				} else {
					$diff = floor( $diff / 86400 );
					$suffix = ($diff == 1)?'day':'days';
				}
				// ignore $format with the backwardtime option
				return '['.$diff.' '.$suffix.' ago]';
			} else {
				return date( $format, $timestamp );
			}
		}
		function unhtmlspecialchars( $string ) {
			$string = str_replace ( '&amp;', '&', $string );
			$string = str_replace ( '&#039;', '\'', $string );
			$string = str_replace ( '&quot;', '"', $string );
			$string = str_replace ( '&lt;', '<', $string );
			$string = str_replace ( '&gt;', '>', $string );
			return $string;
		}
	}
	// sort function
	function compareDate( $a, $b ) {
		return $b->getTimestamp() - $a->getTimestamp();
	}
?>