<?php
	// -- setting --
	$CHARSET = "UTF-8";
	$NUMBER = 1;
	$TIMEOUT = 5;
	$FILE = './RSS_cache/links.xml'
	$HEADER = array( 
		'title'=>'Links',
		'link'=>'http://sourceforge.jp/projects/rsswebreader/',
		'description'=>'RSS Web Reader'
		);
	$RSSURLs = array(
		"http://www.blogpeople.net/display/TB_People/tbp03538.rdf",
		"http://www.blogpeople.net/display/TB_People/tbp00229.rdf",
	);
	// --

	require_once './commonRSS.inc';
	require_once './writeRSS.inc';
	
	$rsswriter = new RSSWriter();
	$file = fopen( $FILE, 'w' ) or die('cannot open the file');
	$rsswriter->setFileHandler( $file );
	$rsswriter->setHeader( $HEADER );
	$rsswriter->showHeader();

	$options = new NewsOptions(
		array(
			'charset'=>$CHARSET,
			'timeout'=>$TIMEOUT,
			'maxitem'=>$NUMBER,
			'untag'=>true,
			'striptag'=>TRUE,
			'excludetag'=>'<p><b><i><ul><li><h3><h4><strong><em>',
		)
	);
	$n = new News( $options );
	for ( $i=0; $i<count($RSSURLs); $i++ ) {
		$result = $n->readRSS( $RSSURLs[$i] );
		if ( !($result && $n->channel && count(get_class_methods($n->channel) ) ) ) {
			continue;
		}
		usort( $n->channel->item, 'compareDate' );
		$iimax = min(count($n->channel->item),$NUMBER);
		for ( $ii=0; $ii<$iimax; $ii++ ) {
			$title = $n->channel->item[$ii]->getTitle();
			$link = $n->channel->item[$ii]->getLink();
			$description = $n->channel->item[$ii]->getSummary();
			$dsc_link = $n->channel->getLink();
			
			$item = array( 
				'title'=>htmlspecialchars($title),
				'link'=>htmlspecialchars($link),
				'pubDate'=>$n->channel->item[$ii]->getTimestamp(),
				'description'=>'<![CDATA['.$description.
					'<p><a href="'.$dsc_link.'">'.$n->channel->getTitle().'</a></p>]]>',
			);
			$rsswriter->setItem( $item );
		}
		$rsswriter->showItems();
		unset( $n->channel );
	}
	$rsswriter->showFooter();
	fclose( $file );
?>
