/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.expression_computer.node;

import java.util.ArrayList;
import java.util.regex.Pattern;
import jp.sourceforge.expression_computer.CompileContext;
import jp.sourceforge.expression_computer.Node;
import jp.sourceforge.expression_computer.command.FunctionCallCommand;
import jp.sourceforge.expression_computer.node.AbstractNode;
import jp.sourceforge.expression_computer.node.OperandNode;

public final class FunctionExpressionNode
extends AbstractNode
implements OperandNode {
    private FunctionNameNode functionName;
    private LeftBracketNode leftBracket;
    private OperandNode[] arguments;
    private CommaNode[] argumentDelimiters;
    private RightBracketNode rightBracket;

    public FunctionExpressionNode(FunctionNameNode functionName, OperandNode[] arguments) {
        int i;
        if (functionName == null) {
            throw new NullPointerException("functionName\u304cnull\u3067\u3059\u3002");
        }
        if (arguments == null) {
            throw new NullPointerException("arguments\u304cnull\u3067\u3059\u3002");
        }
        for (i = 0; i < arguments.length; ++i) {
            if (arguments[i] != null) continue;
            throw new NullPointerException("arguments[" + i + "]\u304cnull\u3067\u3059\u3002");
        }
        this.functionName = functionName;
        this.leftBracket = new LeftBracketNode();
        this.arguments = arguments;
        if (this.arguments.length > 0) {
            this.argumentDelimiters = new CommaNode[this.arguments.length - 1];
            for (i = 0; i < this.argumentDelimiters.length; ++i) {
                this.argumentDelimiters[i] = new CommaNode();
            }
        }
        this.rightBracket = new RightBracketNode();
    }

    public void compile(CompileContext context) {
        for (int i = 0; i < this.arguments.length; ++i) {
            this.arguments[i].compile(context);
        }
        context.getCommandList().add(new FunctionCallCommand(this.functionName.getName(), this.arguments.length));
    }

    public Node[] getChildren() {
        ArrayList<Node> nodeList = new ArrayList<Node>();
        nodeList.add(this.functionName);
        nodeList.add(this.leftBracket);
        for (int i = 0; i < this.arguments.length; ++i) {
            if (i == 0) {
                nodeList.add(this.arguments[i]);
                continue;
            }
            nodeList.add(this.argumentDelimiters[i - 1]);
            nodeList.add(this.arguments[i]);
        }
        nodeList.add(this.rightBracket);
        return nodeList.toArray(new Node[0]);
    }

    public String toString() {
        return this.getClass().getName() + this.toChildrenString();
    }

    public static final class CommaNode
    extends AbstractNode {
        public void compile(CompileContext context) {
            throw new UnsupportedOperationException();
        }

        public Node[] getChildren() {
            return new Node[0];
        }

        public String toString() {
            return this.getClass().getName();
        }
    }

    public static final class RightBracketNode
    extends AbstractNode {
        public void compile(CompileContext context) {
            throw new UnsupportedOperationException();
        }

        public Node[] getChildren() {
            return new Node[0];
        }

        public String toString() {
            return this.getClass().getName();
        }
    }

    public static final class LeftBracketNode
    extends AbstractNode {
        public void compile(CompileContext context) {
            throw new UnsupportedOperationException();
        }

        public Node[] getChildren() {
            return new Node[0];
        }

        public String toString() {
            return this.getClass().getName();
        }
    }

    public static final class FunctionNameNode
    extends AbstractNode {
        private String name;

        public FunctionNameNode(String name) {
            if (name == null) {
                throw new NullPointerException("name\u304cnull\u3067\u3059\u3002");
            }
            if (!Pattern.matches("[\\u0024\\u0041-\\u005a\\u005f\\u0061-\\u007a\\u00c0-\\u00d6\\u00d8-\\u00f6\\u00f8-\\u00ff\\u0100-\\u1fff\\u3040-\\u318f\\u3300-\\u337f\\u3400-\\u3d2d\\u4e00-\\u9fff\\uf900-\\ufaff]([\\u0024\\u0041-\\u005a\\u005f\\u0061-\\u007a\\u00c0-\\u00d6\\u00d8-\\u00f6\\u00f8-\\u00ff\\u0100-\\u1fff\\u3040-\\u318f\\u3300-\\u337f\\u3400-\\u3d2d\\u4e00-\\u9fff\\uf900-\\ufaff]|[\\u0030-\\u0039\\u0660-\\u0669\\u06f0-\\u06f9\\u0966-\\u096f\\u09e6-\\u09ef\\u0a66-\\u0a6f\\u0ae6-\\u0aef\\u0b66-\\u0b6f\\u0be7-\\u0bef\\u0c66-\\u0c6f\\u0ce6-\\u0cef\\u0d66-\\u0d6f\\u0e50-\\u0e59\\u0ed0-\\u0ed9\\u1040-\\u1049])*", name)) {
                throw new IllegalArgumentException("name\u304c\u8b58\u5225\u5b50\u306e\u5f62\u5f0f\u3067\u306f\u3042\u308a\u307e\u305b\u3093\u3002");
            }
            this.name = name;
        }

        public void compile(CompileContext context) {
            throw new UnsupportedOperationException();
        }

        public Node[] getChildren() {
            return new Node[0];
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.getClass().getName() + "[" + this.name + "]";
        }
    }
}

