/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.expression_computer.node;

import jp.sourceforge.expression_computer.Command;
import jp.sourceforge.expression_computer.CommandList;
import jp.sourceforge.expression_computer.CompileContext;
import jp.sourceforge.expression_computer.Node;
import jp.sourceforge.expression_computer.command.AddCommand;
import jp.sourceforge.expression_computer.command.AndCommand;
import jp.sourceforge.expression_computer.command.ArithmeticRightShiftCommand;
import jp.sourceforge.expression_computer.command.DivideCommand;
import jp.sourceforge.expression_computer.command.ExclusiveOrCommand;
import jp.sourceforge.expression_computer.command.InclusiveOrCommand;
import jp.sourceforge.expression_computer.command.LeftShiftCommand;
import jp.sourceforge.expression_computer.command.LogicalRightShiftCommand;
import jp.sourceforge.expression_computer.command.MultiplyCommand;
import jp.sourceforge.expression_computer.command.SetVariableCommand;
import jp.sourceforge.expression_computer.command.SubtractCommand;
import jp.sourceforge.expression_computer.command.SurplusCommand;
import jp.sourceforge.expression_computer.node.AbstractNode;
import jp.sourceforge.expression_computer.node.OperandNode;
import jp.sourceforge.expression_computer.node.VariableNode;

public final class AssignmentExpressionNode
extends AbstractNode
implements OperandNode {
    private VariableNode operand1;
    private OperatorNode operator;
    private OperandNode operand2;

    public AssignmentExpressionNode(VariableNode operand1, OperatorNode operator, OperandNode operand2) {
        if (operand1 == null) {
            throw new NullPointerException("operand1\u304cnull\u3067\u3059\u3002");
        }
        if (operator == null) {
            throw new NullPointerException("operator\u304cnull\u3067\u3059\u3002");
        }
        if (operand2 == null) {
            throw new NullPointerException("operand2\u304cnull\u3067\u3059\u3002");
        }
        this.operand1 = operand1;
        this.operator = operator;
        this.operand2 = operand2;
    }

    public void compile(CompileContext context) {
        this.operand1.compile(context);
        this.operand2.compile(context);
        this.operator.compile(context);
    }

    public Node[] getChildren() {
        return new Node[]{this.operand1, this.operator, this.operand2};
    }

    public String toString() {
        return this.getClass().getName() + this.toChildrenString();
    }

    public static final class LogicalRightShiftEqualNode
    extends OperatorNode {
        public void compile(CompileContext context) {
            CommandList cl = context.getCommandList();
            Command c = cl.getCommand(cl.size() - 2);
            cl.addCommand(cl.size() - 1, c);
            cl.add(new LogicalRightShiftCommand());
            cl.add(new SetVariableCommand());
        }

        public String toString() {
            return this.getClass().getName();
        }
    }

    public static final class ArithmeticRightShiftEqualNode
    extends OperatorNode {
        public void compile(CompileContext context) {
            CommandList cl = context.getCommandList();
            Command c = cl.getCommand(cl.size() - 2);
            cl.addCommand(cl.size() - 1, c);
            cl.add(new ArithmeticRightShiftCommand());
            cl.add(new SetVariableCommand());
        }

        public String toString() {
            return this.getClass().getName();
        }
    }

    public static final class LeftShiftEqualNode
    extends OperatorNode {
        public void compile(CompileContext context) {
            CommandList cl = context.getCommandList();
            Command c = cl.getCommand(cl.size() - 2);
            cl.addCommand(cl.size() - 1, c);
            cl.add(new LeftShiftCommand());
            cl.add(new SetVariableCommand());
        }

        public String toString() {
            return this.getClass().getName();
        }
    }

    public static final class InclusiveOrEqualNode
    extends OperatorNode {
        public void compile(CompileContext context) {
            CommandList cl = context.getCommandList();
            Command c = cl.getCommand(cl.size() - 2);
            cl.addCommand(cl.size() - 1, c);
            cl.add(new InclusiveOrCommand());
            cl.add(new SetVariableCommand());
        }

        public String toString() {
            return this.getClass().getName();
        }
    }

    public static final class ExclusiveOrEqualNode
    extends OperatorNode {
        public void compile(CompileContext context) {
            CommandList cl = context.getCommandList();
            Command c = cl.getCommand(cl.size() - 2);
            cl.addCommand(cl.size() - 1, c);
            cl.add(new ExclusiveOrCommand());
            cl.add(new SetVariableCommand());
        }

        public String toString() {
            return this.getClass().getName();
        }
    }

    public static final class AndEqualNode
    extends OperatorNode {
        public void compile(CompileContext context) {
            CommandList cl = context.getCommandList();
            Command c = cl.getCommand(cl.size() - 2);
            cl.addCommand(cl.size() - 1, c);
            cl.add(new AndCommand());
            cl.add(new SetVariableCommand());
        }

        public String toString() {
            return this.getClass().getName();
        }
    }

    public static final class SurplusEqualNode
    extends OperatorNode {
        public void compile(CompileContext context) {
            CommandList cl = context.getCommandList();
            Command c = cl.getCommand(cl.size() - 2);
            cl.addCommand(cl.size() - 1, c);
            cl.add(new SurplusCommand());
            cl.add(new SetVariableCommand());
        }

        public String toString() {
            return this.getClass().getName();
        }
    }

    public static final class DivideEqualNode
    extends OperatorNode {
        public void compile(CompileContext context) {
            CommandList cl = context.getCommandList();
            Command c = cl.getCommand(cl.size() - 2);
            cl.addCommand(cl.size() - 1, c);
            cl.add(new DivideCommand());
            cl.add(new SetVariableCommand());
        }

        public String toString() {
            return this.getClass().getName();
        }
    }

    public static final class MultiplyEqualNode
    extends OperatorNode {
        public void compile(CompileContext context) {
            CommandList cl = context.getCommandList();
            Command c = cl.getCommand(cl.size() - 2);
            cl.addCommand(cl.size() - 1, c);
            cl.add(new MultiplyCommand());
            cl.add(new SetVariableCommand());
        }

        public String toString() {
            return this.getClass().getName();
        }
    }

    public static final class SubtractEqualNode
    extends OperatorNode {
        public void compile(CompileContext context) {
            CommandList cl = context.getCommandList();
            Command c = cl.getCommand(cl.size() - 2);
            cl.addCommand(cl.size() - 1, c);
            cl.add(new SubtractCommand());
            cl.add(new SetVariableCommand());
        }

        public String toString() {
            return this.getClass().getName();
        }
    }

    public static final class AddEqualNode
    extends OperatorNode {
        public void compile(CompileContext context) {
            CommandList cl = context.getCommandList();
            Command c = cl.getCommand(cl.size() - 2);
            cl.addCommand(cl.size() - 1, c);
            cl.add(new AddCommand());
            cl.add(new SetVariableCommand());
        }

        public String toString() {
            return this.getClass().getName();
        }
    }

    public static final class EqualNode
    extends OperatorNode {
        public void compile(CompileContext context) {
            context.getCommandList().add(new SetVariableCommand());
        }

        public String toString() {
            return this.getClass().getName();
        }
    }

    public static abstract class OperatorNode
    extends AbstractNode {
        public final Node[] getChildren() {
            return new Node[0];
        }
    }
}

