/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.expression_computer.command;

import jp.sourceforge.expression_computer.Command;
import jp.sourceforge.expression_computer.ComputeContext;
import jp.sourceforge.expression_computer.Function;
import jp.sourceforge.expression_computer.type.FloatingPointLiteral;
import jp.sourceforge.expression_computer.util.Validator;

public final class FunctionCallCommand
implements Command {
    private String name;
    private int argumentNumber;

    public FunctionCallCommand(String name, int argumentNumber) {
        if (name == null) {
            throw new NullPointerException("name\u304cnull\u3067\u3059\u3002");
        }
        if (!Validator.isIdentifier(name)) {
            throw new IllegalArgumentException("name\u304c\u8b58\u5225\u5b50\u306e\u5f62\u5f0f\u3067\u306f\u3042\u308a\u307e\u305b\u3093\u3002");
        }
        if (argumentNumber < 0) {
            throw new IllegalArgumentException("{argumentNumber < 0}\u3067\u3059\u3002");
        }
        this.name = name;
        this.argumentNumber = argumentNumber;
    }

    public void execute(ComputeContext context) {
        Function func = context.getFunction(this.name);
        double[] arguments = new double[this.argumentNumber];
        for (int i = this.argumentNumber - 1; i >= 0; --i) {
            arguments[i] = context.popStack().getValue(context);
        }
        double resultValue = func.call(arguments);
        context.pushStack(new FloatingPointLiteral(resultValue));
    }

    public String getName() {
        return this.name;
    }

    public int getArgumentNumber() {
        return this.argumentNumber;
    }

    public String toString() {
        return this.getClass().getName() + "[name=" + this.name + ", argumentNumber=" + this.argumentNumber + "]";
    }
}

