/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.expression_computer;

import java.util.Iterator;
import jp.sourceforge.expression_computer.Command;
import jp.sourceforge.expression_computer.CommandList;
import jp.sourceforge.expression_computer.Compiler;
import jp.sourceforge.expression_computer.ComputeContext;
import jp.sourceforge.expression_computer.ComputeException;
import jp.sourceforge.expression_computer.Function;
import jp.sourceforge.expression_computer.Node;
import jp.sourceforge.expression_computer.Parser;

public final class Computer {
    private ComputeContext context = new ComputeContext();

    public void setVariable(String name, double value) {
        this.context.setVariable(name, value);
    }

    public double getVariable(String name) {
        return this.context.getVariable(name);
    }

    public String[] getVariableNames() {
        return this.context.getVariableNames();
    }

    public void addFunction(String name, Function func) {
        this.context.addFunction(name, func);
    }

    public double compute(String expression) {
        Parser parser = new Parser();
        Node node = parser.parse(expression);
        Compiler compiler = new Compiler();
        CommandList commandList = compiler.compile(node);
        return this.compute(commandList);
    }

    public double compute(CommandList commandList) {
        if (commandList == null) {
            throw new NullPointerException("commandList\u304cnull\u3067\u3059\u3002");
        }
        Iterator i = commandList.iterator();
        while (i.hasNext()) {
            Command c = (Command)i.next();
            c.execute(this.context);
        }
        if (this.context.sizeStack() == 0) {
            throw new ComputeException("\u8a08\u7b97\u7d42\u4e86\u5f8c\u306b\u30b9\u30bf\u30c3\u30af\u306b\u7d50\u679c\u306e\u5024\u304c\u8ffd\u52a0\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
        }
        if (this.context.sizeStack() > 1) {
            throw new ComputeException("\u8a08\u7b97\u7d42\u4e86\u5f8c\u306b\u30b9\u30bf\u30c3\u30af\u306b\u8ffd\u52a0\u3055\u308c\u3066\u3044\u308b\u6570\u304c2\u3064\u4ee5\u4e0a\u3042\u308a\u307e\u3059\u3002");
        }
        double resultValue = this.context.popStack().getValue(this.context);
        return resultValue;
    }
}

