
package jp.sourceforge.torkenizer.test;

import jp.sourceforge.tokenizer.Token;

/**
 * <p>
 * トークンの基底抽象クラスです。
 * </p>
 * 
 * @author uguu@users.sourceforge.jp
 */
public class AbstractToken implements Token {

    private String token;

    private int    line;

    private int    column;

    /**
     * <p>
     * インスタンスを初期化します。
     * </p>
     * 
     * @param token
     *            トークンの文字列。
     * @param line
     *            行番号。
     * @param column
     *            列番号。
     */
    public AbstractToken(String token, int line, int column) {
        this.token = token;
        this.line = line;
        this.column = column;
    }

    public String getToken() {
        return this.token;
    }

    public int getLine() {
        return this.line;
    }

    public int getColumn() {
        return this.column;
    }

}
