
package jp.sourceforge.rpn_computer.test;

import jp.sourceforge.rpn_computer.RpnCommandList;
import jp.sourceforge.rpn_computer.RpnCompiler;
import jp.sourceforge.rpn_computer.RpnComputer;
import jp.sourceforge.rpn_computer.RpnNode;
import jp.sourceforge.rpn_computer.RpnParser;
import junit.framework.TestCase;

/**
 * {@link RpnComputer}クラスに関するテストを行います。
 * 
 * @author uguu@users.sourceforge.jp
 */
public class RpnComputerTest extends TestCase {

    /**
     * インスタンスを初期化します。
     * 
     * @param name
     *            テストの名前。
     */
    public RpnComputerTest(String name) {
        super(name);
    }

    /**
     * 正常系テスト1。
     */
    public void testNormal1() {
        String exp = "1 + 2";

        RpnParser parser = new RpnParser();
        RpnNode node = parser.parse(exp);

        RpnCompiler compiler = new RpnCompiler();
        RpnCommandList cl = compiler.compile(node);

        RpnComputer computer = new RpnComputer();
        double resultValue = computer.compute(cl);

        assertEquals(3, resultValue, 0);
    }

    /**
     * 正常系テスト2。
     */
    public void testNormal2() {
        String exp = "(12.34 + 56.78) * 3.14";

        RpnParser parser = new RpnParser();
        RpnNode node = parser.parse(exp);

        RpnCompiler compiler = new RpnCompiler();
        RpnCommandList cl = compiler.compile(node);

        RpnComputer computer = new RpnComputer();
        double resultValue = computer.compute(cl);

        assertEquals(217.0368, resultValue, 0.00000000001);
    }

    /**
     * 正常系テスト3。
     */
    public void testNormal3() {
        String exp = "(12.34 + 56.78) * 3.14";

        RpnComputer computer = new RpnComputer();
        double resultValue = computer.compute(exp);

        assertEquals(217.0368, resultValue, 0.00000000001);
    }

    /**
     * 異常系テスト1。 commandListがnullのときに{@link NullPointerException}例外がスローされることを確認します。
     */
    public void testFail1() {
        RpnComputer comp = new RpnComputer();
        try {
            comp.compute((RpnCommandList) null);
            fail();
        } catch (NullPointerException e) {
            assertEquals("commandListがnullです。", e.getMessage());
        }
    }
}
