/*
 * Copyright (C) 2006 uguu@users.sourceforge.jp, All Rights Reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 *    1. Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *
 *    2. Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *
 *    3. Neither the name of Clarkware Consulting, Inc. nor the names of its
 *       contributors may be used to endorse or promote products derived
 *       from this software without prior written permission. For written
 *       permission, please contact clarkware@clarkware.com.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL
 * CLARKWARE CONSULTING OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA,
 * OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN  ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package jp.sourceforge.rpn_computer.node;

import jp.sourceforge.rpn_computer.ParseException;
import jp.sourceforge.rpn_computer.RpnCompileContext;
import jp.sourceforge.rpn_computer.RpnNode;
import jp.sourceforge.rpn_computer.token.MinusToken;
import jp.sourceforge.rpn_computer.token.MinusTokenInfo;
import jp.sourceforge.rpn_computer.token.PlusToken;
import jp.sourceforge.rpn_computer.token.PlusTokenInfo;
import jp.sourceforge.rpn_computer.token.SkipTokenInfo;
import jp.sourceforge.tokenizer.Token;
import jp.sourceforge.tokenizer.TokenInfo;
import jp.sourceforge.tokenizer.Tokenizer;

/**
 * <p>
 * AdditiveExpressionを表すノードです。
 * </p>
 * 
 * @author uguu@users.sourceforge.jp
 */
public final class AdditiveExpressionNode extends AbstractNode {

    /**
     * {@inheritDoc}
     */
    public void parse(Tokenizer tokenizer) {
        RpnNode node = new MultiplicativeExpressionNode();
        node.parse(tokenizer);
        this.addNode(node);

        TokenInfo[] readTokenInfos = new TokenInfo[] { new PlusTokenInfo(), new MinusTokenInfo(), };
        TokenInfo[] skipTokenInfos = new TokenInfo[] { new SkipTokenInfo(), };
        if (tokenizer.read(readTokenInfos, skipTokenInfos)) {
            Token token = tokenizer.current();
            if (token instanceof PlusToken) {
                node = new AddNode();
            } else if (token instanceof MinusToken) {
                node = new SubtractNode();
            } else {
                throw new ParseException(token, readTokenInfos);
            }
            node.parse(tokenizer);
            this.addNode(node);

            node = new AdditiveExpressionNode();
            node.parse(tokenizer);
            this.addNode(node);
        }
    }

    /**
     * {@inheritDoc}
     */
    public String toString() {
        return "additive expression\n" + this.toChildrenString();
    }

    /**
     * {@inheritDoc}
     */
    public void compile(RpnCompileContext context) {
        RpnNode[] nodes = this.getChildren();

        if (nodes.length == 1) {
            nodes[0].compile(context);
        } else {
            nodes[0].compile(context);
            nodes[2].compile(context);
            nodes[1].compile(context);
        }
    }
}
