/*
 * Copyright (C) 2006 uguu@users.sourceforge.jp, All Rights Reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 *    1. Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *
 *    2. Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *
 *    3. Neither the name of Clarkware Consulting, Inc. nor the names of its
 *       contributors may be used to endorse or promote products derived
 *       from this software without prior written permission. For written
 *       permission, please contact clarkware@clarkware.com.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL
 * CLARKWARE CONSULTING OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA,
 * OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN  ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package jp.sourceforge.rpn_computer;

import jp.sourceforge.tokenizer.Tokenizer;

/**
 * <p>
 * 抽象構文木のノードを表します。
 * </p>
 * 
 * @author uguu@users.sourceforge.jp
 */
public interface RpnNode {

    /**
     * <p>
     * {@link Tokenizer}クラスからトークンを読み込み、ノードを構築してください。
     * </p>
     * 
     * @param tokenizer
     *            トークンを読み込む字句解析器。
     */
    void parse(Tokenizer tokenizer);

    /**
     * <p>
     * ノードから命令列を生成して、コンテキストに追加してください。
     * </p>
     * 
     * @param context
     *            コンテキスト。
     */
    void compile(RpnCompileContext context);

    /**
     * <p>
     * 子ノードの配列を返してください。このノードがリーフである場合、要素が0の配列を返してください。nullを返した場合、他の処理で例外がスローされる可能性があります(例えば、構文木をトラバースするとき)。
     * </p>
     * 
     * @return 子ノードの配列。
     */
    RpnNode[] getChildren();
}
