/*
 * Decompiled with CFR 0.152.
 */
package jp.robotbrain.ui.graph;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JPanel;
import javax.swing.event.EventListenerList;
import jp.robotbrain.common.UtilDouble;
import jp.robotbrain.signal.CandleStick;
import jp.robotbrain.signal.CoreFramework;
import jp.robotbrain.signal.IndexObject;
import jp.robotbrain.signal.IndexObjectList;
import jp.robotbrain.signal.IndexPoint;
import jp.robotbrain.signal.NmViewType;
import jp.robotbrain.signal.Tag;
import jp.robotbrain.ui.graph.GraphEvent;
import jp.robotbrain.ui.graph.GraphException;
import jp.robotbrain.ui.graph.GraphLayer;
import jp.robotbrain.ui.graph.GraphLayerList;
import jp.robotbrain.ui.graph.GraphListener;

public class GraphPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private GraphLayerList m_graphLayerList;
    private GraphLayerList m_paintGraphLayerList;
    private int m_indexWidth;
    private Color m_cursorColor;
    private int m_cursorX;
    private float m_lineWidth;
    private Color m_rulerColor;
    private Color m_subLayerRectColor;
    private Color m_titleBarBackColor;
    private Color m_titleBarForeColor;
    private Color m_emptyMessageForeColor;
    private IndexObjectList<IndexPoint> m_statusLine;
    private Font m_titleBarFont;
    private Font m_rulerFont;
    private Font m_emptyMessageFont;
    private CoreFramework m_signalBox;
    private int m_mainLayerHeightRatio;
    private boolean m_showSubLayerRect;
    private int m_titleBarTopOffset;
    private int m_indexBottomOffset;
    private EventListenerList m_eventListenerList;
    private boolean m_empty;
    private boolean m_prevEmpty;
    private String m_emptyMessage;

    public GraphPanel() {
        this.setBorder(null);
        this.m_graphLayerList = new GraphLayerList(this);
        this.m_paintGraphLayerList = new GraphLayerList(this);
        this.m_indexWidth = 3;
        this.m_cursorX = -1;
        this.m_lineWidth = 1.0f;
        this.m_cursorColor = Color.PINK;
        this.m_rulerColor = new Color(153, 153, 102);
        this.m_titleBarBackColor = new Color(102, 153, 51);
        this.m_titleBarForeColor = Color.WHITE;
        this.m_mainLayerHeightRatio = 70;
        this.m_subLayerRectColor = Color.YELLOW;
        this.m_showSubLayerRect = false;
        this.m_titleBarTopOffset = 5;
        this.m_indexBottomOffset = 5;
        this.m_eventListenerList = new EventListenerList();
        this.m_empty = true;
        this.m_prevEmpty = true;
    }

    public void writeImage(String p_imageFilePath, String p_imageFormat) throws IOException {
        BufferedImage bufImage = (BufferedImage)this.createImage(this.getWidth(), this.getHeight());
        Graphics2D bufGraphics = bufImage.createGraphics();
        bufGraphics.setColor(this.getBackground());
        bufGraphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        this.paintGraph(bufGraphics);
        ImageIO.write((RenderedImage)bufImage, p_imageFormat, new File(p_imageFilePath));
    }

    @Override
    protected void paintComponent(Graphics p_graphics) {
        super.paintComponent(p_graphics);
        this.paintGraph(p_graphics);
    }

    public synchronized void paintGraph(Graphics p_graphics) {
        Graphics2D graphics2D = (Graphics2D)p_graphics;
        try {
            this.m_empty = true;
            if (this.m_paintGraphLayerList.getValues().size() <= 0) {
                return;
            }
            Font fontBackup = p_graphics.getFont();
            if (this.m_rulerFont != null) {
                p_graphics.setFont(this.m_rulerFont);
            }
            for (GraphLayer layer : this.m_paintGraphLayerList.getValues()) {
                layer.setPrevTag(null);
                layer.setIndexTopOffset(this.getFontHeight(graphics2D));
            }
            p_graphics.setFont(fontBackup);
            GraphLayer mainLayer = this.getPaintMainLayer();
            if (mainLayer == null) {
                return;
            }
            if (mainLayer.getPaintSrcList().size() < 2) {
                return;
            }
            this.m_empty = false;
            int top = 0;
            GraphLayer prevLayer = null;
            int i = 0;
            while (i < this.m_paintGraphLayerList.getValues().size()) {
                GraphLayer layer = this.m_paintGraphLayerList.getValues().get(i);
                if (prevLayer != null && (layer.getLayerNo() < 0 || layer.getLayerNo() != prevLayer.getLayerNo())) {
                    top += this.getHeight() * prevLayer.getHeightRatio() / 100;
                }
                if (layer.getRuler().isVisible()) {
                    layer.setTop(top);
                    this.drawRulerAndTitleBar(graphics2D, layer);
                }
                prevLayer = layer;
                ++i;
            }
            this.drawCursor(graphics2D);
            if (this.m_showSubLayerRect) {
                this.drawSubLayerRect(graphics2D);
            }
            i = 0;
            while (i < mainLayer.getPaintSrcList().size()) {
                Object main = mainLayer.getPaintSrcList().get(i);
                top = 0;
                prevLayer = null;
                for (GraphLayer layer : this.m_paintGraphLayerList.getValues()) {
                    if (prevLayer != null && (layer.getLayerNo() < 0 || layer.getLayerNo() != prevLayer.getLayerNo())) {
                        top += this.getHeight() * prevLayer.getHeightRatio() / 100;
                    }
                    layer.setTop(top);
                    if (layer.getPaintSrcList().getViewType() == NmViewType.INDEXLINE || layer.getPaintSrcList().getViewType() == NmViewType.INDEXLINE_PERCENTAGE) {
                        this.drawIndexLine(graphics2D, layer, ((IndexObject)main).getTag());
                    } else if (layer.getPaintSrcList().getViewType() == NmViewType.CANDLESTICKLIST) {
                        this.drawCandleStickList(graphics2D, layer, ((IndexObject)main).getTag());
                    }
                    prevLayer = layer;
                }
                ++i;
            }
        }
        finally {
            if (this.m_empty) {
                this.drawEmptyMessage(graphics2D);
            }
            if (this.m_empty != this.m_prevEmpty) {
                this.fireGraphUpdatedEvent();
                this.m_prevEmpty = this.m_empty;
            }
            graphics2D.dispose();
        }
    }

    public void addUpdatedListener(GraphListener p_listener) {
        this.m_eventListenerList.add(GraphListener.class, p_listener);
    }

    public void removeUpdatedListener(GraphListener p_listener) {
        this.m_eventListenerList.remove(GraphListener.class, p_listener);
    }

    protected void fireGraphUpdatedEvent() {
        Object[] listenerList = this.m_eventListenerList.getListenerList();
        GraphEvent event = new GraphEvent(this);
        int i = listenerList.length - 2;
        while (i >= 0) {
            if (listenerList[i] == GraphListener.class) {
                ((GraphListener)listenerList[i + 1]).updated(event);
            }
            i -= 2;
        }
    }

    private GraphLayer getPaintMainLayer() {
        if (this.m_paintGraphLayerList.getValues().size() <= 0) {
            return null;
        }
        return this.m_paintGraphLayerList.getValues().get(0);
    }

    protected GraphLayer getMainLayer() {
        if (this.m_graphLayerList.getValues().size() <= 0) {
            return null;
        }
        return this.m_graphLayerList.getValues().get(0);
    }

    private void drawCursor(Graphics2D p_graphics2D) {
        if (this.m_cursorX > 0) {
            BasicStroke stroke = new BasicStroke(1.0f);
            p_graphics2D.setStroke(stroke);
            p_graphics2D.setColor(this.m_cursorColor);
            p_graphics2D.fillRect(this.getCursorXPointCount() * this.m_indexWidth, 0, this.m_indexWidth, this.getHeight());
        }
    }

    private void drawSubLayerRect(Graphics2D p_graphics2D) {
        BasicStroke stroke = new BasicStroke(2.0f);
        p_graphics2D.setStroke(stroke);
        p_graphics2D.setColor(this.m_subLayerRectColor);
        int y = this.getHeight() * this.m_mainLayerHeightRatio / 100;
        p_graphics2D.drawRect(2, y + this.m_titleBarTopOffset + 5, this.getWidth() - 5, this.getHeight() * (100 - this.m_mainLayerHeightRatio) / 100 - this.m_titleBarTopOffset - 7);
    }

    private int calcStringWidth(Graphics2D p_graphics2D, String p_value) {
        FontMetrics fm = p_graphics2D.getFontMetrics();
        int returnValue = 0;
        int j = 0;
        while (j < p_value.length()) {
            returnValue += fm.charWidth(p_value.charAt(j));
            ++j;
        }
        return returnValue;
    }

    private int getFontHeight(Graphics2D p_graphics2D) {
        FontMetrics fm = p_graphics2D.getFontMetrics();
        return fm.getHeight();
    }

    private void drawEmptyMessage(Graphics2D p_graphics2D) {
        if (this.m_emptyMessage == null) {
            return;
        }
        Font fontBackup = p_graphics2D.getFont();
        if (this.m_emptyMessageFont != null) {
            p_graphics2D.setFont(this.m_emptyMessageFont);
        }
        if (this.m_emptyMessageForeColor != null) {
            p_graphics2D.setColor(this.m_emptyMessageForeColor);
        }
        int viewStringWidth = this.calcStringWidth(p_graphics2D, this.m_emptyMessage);
        p_graphics2D.drawString(this.m_emptyMessage, this.getWidth() / 2 - viewStringWidth / 2, this.getHeight() / 2);
        p_graphics2D.setFont(fontBackup);
    }

    private void drawRulerAndTitleBar(Graphics2D p_graphics2D, GraphLayer p_layer) {
        BasicStroke stroke = new BasicStroke(1.0f);
        p_graphics2D.setStroke(stroke);
        p_graphics2D.setColor(this.m_titleBarBackColor);
        int titleBarTop = p_layer.getTitleBarTop();
        p_graphics2D.fillRect(0, titleBarTop, this.getWidth(), p_layer.getTitleBarHeight());
        if (!p_layer.getTitle().isEmpty()) {
            Font fontBackup = p_graphics2D.getFont();
            if (this.m_titleBarFont != null) {
                p_graphics2D.setFont(this.m_titleBarFont);
            }
            int fontHeight = this.getFontHeight(p_graphics2D);
            int fontAscent = p_graphics2D.getFontMetrics().getAscent();
            p_graphics2D.setColor(this.m_titleBarForeColor);
            int titleOffset = (p_layer.getTitleBarHeight() - fontHeight) / 2;
            if (titleOffset < 0) {
                titleOffset = 0;
            }
            p_graphics2D.drawString(p_layer.getTitle(), 4, titleBarTop + titleOffset + fontAscent);
            p_graphics2D.setFont(fontBackup);
        }
        float[] dash = new float[]{2.0f, 3.0f};
        stroke = new BasicStroke(1.0f, 0, 0, 10.0f, dash, 0.0f);
        p_graphics2D.setStroke(stroke);
        p_graphics2D.setColor(this.m_rulerColor);
        if (p_layer.getRuler().getStep() <= 0.0) {
            return;
        }
        double i = p_layer.getRuler().getMax();
        while (i >= p_layer.getRuler().getMin()) {
            int y = p_layer.calcY(i, this.getHeight());
            p_graphics2D.drawLine(0, y, this.getWidth(), y);
            Font fontBackup = p_graphics2D.getFont();
            if (this.m_rulerFont != null) {
                p_graphics2D.setFont(this.m_rulerFont);
            }
            int fontHeight = this.getFontHeight(p_graphics2D);
            int fontAscent = p_graphics2D.getFontMetrics().getAscent();
            String viewString = UtilDouble.format(i, p_layer.getRuler().getScale());
            int viewStringWidth = this.calcStringWidth(p_graphics2D, viewString);
            int stringY = y - fontHeight + fontAscent;
            p_graphics2D.drawString(viewString, this.getWidth() / 3 - viewStringWidth, stringY);
            p_graphics2D.drawString(viewString, this.getWidth() - viewStringWidth - 10, stringY);
            p_graphics2D.setFont(fontBackup);
            i -= p_layer.getRuler().getStep();
        }
    }

    private void drawIndexLine(Graphics2D p_graphics2D, GraphLayer p_layer, Tag p_mainLayerTag) {
        IndexPoint current = (IndexPoint)p_layer.getPaintSrcList().get(p_mainLayerTag);
        if (current == null) {
            return;
        }
        IndexPoint prev = (IndexPoint)p_layer.getPaintSrcList().get(p_layer.getPrevTag());
        if (prev == null) {
            p_layer.setPrevTag(p_mainLayerTag);
            return;
        }
        int prevPointer = this.getPaintMainLayer().getPaintSrcList().indexOf(prev) + 1;
        int currentPointer = this.getPaintMainLayer().getPaintSrcList().indexOf(current) + 1;
        int prevX = prevPointer * this.m_indexWidth;
        int currentX = currentPointer * this.m_indexWidth;
        int prevY = p_layer.calcY(prev.getValue(), this.getHeight());
        int currentY = p_layer.calcY(current.getValue(), this.getHeight());
        BasicStroke stroke = new BasicStroke(this.m_lineWidth);
        p_graphics2D.setStroke(stroke);
        if (p_layer.isStatusColor() && this.m_statusLine != null) {
            IndexPoint status = this.m_statusLine.get(p_mainLayerTag);
            if (status != null) {
                p_graphics2D.setColor(status.getColor());
            }
        } else {
            Object indexObject = p_layer.getPaintSrcList().get(p_mainLayerTag);
            if (indexObject != null && ((IndexObject)indexObject).getColor() != null) {
                p_graphics2D.setColor(((IndexObject)indexObject).getColor());
            } else {
                p_graphics2D.setColor(p_layer.getForeColor());
            }
        }
        p_graphics2D.drawLine(prevX, prevY, currentX - 1, currentY);
        p_layer.setPrevTag(p_mainLayerTag);
    }

    private void drawCandleStickList(Graphics2D p_graphics2D, GraphLayer p_layer, Tag p_mainLayerTag) {
        CandleStick current = (CandleStick)p_layer.getPaintSrcList().get(p_mainLayerTag);
        if (current == null) {
            return;
        }
        int currentPointer = this.getPaintMainLayer().getPaintSrcList().indexOf(current);
        int currentX = currentPointer * this.m_indexWidth;
        int currentY = 0;
        int height = 0;
        int higeHighY = -1;
        int higeLowY = -1;
        Color fillColor = Color.WHITE;
        if (current.getOpen() <= current.getClose()) {
            currentY = p_layer.calcY(current.getClose(), this.getHeight());
            height = p_layer.calcYDistance(current.getClose() - current.getOpen(), this.getHeight());
            fillColor = current.getPlusColor();
            if (current.getHigh() > current.getClose()) {
                higeHighY = p_layer.calcY(current.getHigh(), this.getHeight());
            }
            if (current.getLow() < current.getOpen()) {
                higeLowY = p_layer.calcY(current.getLow(), this.getHeight());
            }
        } else {
            currentY = p_layer.calcY(current.getOpen(), this.getHeight());
            height = p_layer.calcYDistance(current.getOpen() - current.getClose(), this.getHeight());
            fillColor = current.getMinusColor();
            if (current.getHigh() > current.getOpen()) {
                higeHighY = p_layer.calcY(current.getHigh(), this.getHeight());
            }
            if (current.getLow() < current.getClose()) {
                higeLowY = p_layer.calcY(current.getLow(), this.getHeight());
            }
        }
        BasicStroke stroke = new BasicStroke(this.m_lineWidth);
        p_graphics2D.setStroke(stroke);
        if (p_layer.isStatusColor() && this.m_statusLine != null) {
            IndexPoint status = this.m_statusLine.get(p_mainLayerTag);
            if (status != null) {
                p_graphics2D.setColor(status.getColor());
            }
        } else {
            Object indexObject = p_layer.getPaintSrcList().get(p_mainLayerTag);
            if (indexObject != null && ((IndexObject)indexObject).getColor() != null) {
                p_graphics2D.setColor(((IndexObject)indexObject).getColor());
            } else {
                p_graphics2D.setColor(p_layer.getForeColor());
            }
        }
        p_graphics2D.drawRect(currentX, currentY, this.m_indexWidth - 1, height);
        int higeX = currentX + this.m_indexWidth / 2;
        if (higeHighY > 0) {
            p_graphics2D.drawLine(higeX, currentY, higeX, higeHighY);
        }
        if (higeLowY > 0) {
            p_graphics2D.drawLine(higeX, currentY, higeX, higeLowY);
        }
        p_graphics2D.setColor(fillColor);
        int fillOffset = Math.round(this.m_lineWidth / 2.0f);
        int lineWidth = (int)this.m_lineWidth;
        p_graphics2D.fillRect(currentX + fillOffset, currentY + fillOffset, this.m_indexWidth - lineWidth - 1, height - lineWidth * 1);
        p_layer.setPrevTag(p_mainLayerTag);
    }

    public int getCursorXPointCount() {
        return this.m_cursorX / this.m_indexWidth;
    }

    public int getWidthPointCount() {
        return this.getWidth() / this.m_indexWidth;
    }

    public IndexObject getCursorPoint() {
        Object src;
        GraphLayer mainLayer = this.getPaintMainLayer();
        if (mainLayer == null) {
            return null;
        }
        if (mainLayer.getPaintSrcList().size() <= this.getWidthPointCount()) {
            src = mainLayer.getPaintSrcList().get(this.getCursorXPointCount());
        } else {
            int tailIndex = this.getWidthPointCount() - this.getCursorXPointCount();
            if (mainLayer.getPaintSrcList().size() <= tailIndex) {
                return null;
            }
            src = mainLayer.getPaintSrcList().get(mainLayer.getPaintSrcList().size() - tailIndex);
        }
        if (src == null) {
            return null;
        }
        if (this.m_statusLine == null) {
            return src;
        }
        return this.m_statusLine.get(((IndexObject)src).getTag());
    }

    public IndexObject getLastPoint() {
        GraphLayer mainLayer = this.getPaintMainLayer();
        if (mainLayer == null) {
            return null;
        }
        return mainLayer.getPaintSrcList().getLast();
    }

    public void movePrevCursor() {
        if (this.m_cursorX - this.m_indexWidth > 0) {
            this.m_cursorX -= this.m_indexWidth;
        }
    }

    public void moveNextCursor() {
        if (this.m_cursorX + this.m_indexWidth < this.getWidth()) {
            this.m_cursorX += this.m_indexWidth;
        }
    }

    public int getCursorX() {
        return this.m_cursorX;
    }

    public void setCursorX(int p_cursorX) {
        this.m_cursorX = p_cursorX;
    }

    public Color getCursorColor() {
        return this.m_cursorColor;
    }

    public void setCursorColor(Color p_cursorColor) {
        this.m_cursorColor = p_cursorColor;
    }

    public int getIndexWidth() {
        return this.m_indexWidth;
    }

    public void setIndexWidth(int p_pointWidth) {
        this.m_indexWidth = p_pointWidth;
    }

    public float getLineWidth() {
        return this.m_lineWidth;
    }

    public void setLineWidth(float p_lineWidth) {
        this.m_lineWidth = p_lineWidth;
    }

    public Color getRulerColor() {
        return this.m_rulerColor;
    }

    public void setRulerColor(Color p_rulerColor) {
        this.m_rulerColor = p_rulerColor;
    }

    public Color getTitleBarBackColor() {
        return this.m_titleBarBackColor;
    }

    public void setTitleBarBackColor(Color p_titleBarBackColor) {
        this.m_titleBarBackColor = p_titleBarBackColor;
    }

    public Color getTitleBarForeColor() {
        return this.m_titleBarForeColor;
    }

    public void setTitleBarForeColor(Color p_titleBarForeColor) {
        this.m_titleBarForeColor = p_titleBarForeColor;
    }

    public Font getTitleBarFont() {
        return this.m_titleBarFont;
    }

    public void setTitleBarFont(Font p_titleBarFont) {
        this.m_titleBarFont = p_titleBarFont;
    }

    public Font getRulerFont() {
        return this.m_rulerFont;
    }

    public void setRulerFont(Font p_rulerFont) {
        this.m_rulerFont = p_rulerFont;
    }

    public Color getSubLayerRectColor() {
        return this.m_subLayerRectColor;
    }

    public void setSubLayerRectColor(Color p_subLayerRectColor) {
        this.m_subLayerRectColor = p_subLayerRectColor;
    }

    public boolean isShowSubLayerRect() {
        return this.m_showSubLayerRect;
    }

    public void setShowSubLayerRect(boolean p_showSubLayerRect) {
        this.m_showSubLayerRect = p_showSubLayerRect;
    }

    public int getTitleBarTopOffset() {
        return this.m_titleBarTopOffset;
    }

    public void setTitleBarTopOffset(int p_titleBarTopOffset) {
        this.m_titleBarTopOffset = p_titleBarTopOffset;
    }

    public int getIndexBottomOffset() {
        return this.m_indexBottomOffset;
    }

    public void setIndexBottomOffset(int p_indexBottomOffset) {
        this.m_indexBottomOffset = p_indexBottomOffset;
    }

    public void setStatusLine(IndexObjectList<IndexPoint> p_statusLine) {
        this.m_statusLine = p_statusLine;
    }

    public int getMainLayerHeightRatio() {
        return this.m_mainLayerHeightRatio;
    }

    public void setMainLayerHeightRatio(int p_mainLayerHeightRatio) {
        this.m_mainLayerHeightRatio = p_mainLayerHeightRatio;
    }

    public void preparePaint() {
        GraphLayer graphLayer;
        int i;
        try {
            this.m_paintGraphLayerList = this.m_graphLayerList.clone();
            this.m_paintGraphLayerList.init();
        }
        catch (GraphException e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
        if (this.m_paintGraphLayerList.getMaxLayerNo() > 0) {
            i = 0;
            while (i < this.m_paintGraphLayerList.getValues().size()) {
                graphLayer = this.m_paintGraphLayerList.getValues().get(i);
                int no = graphLayer.getLayerNo();
                if (no == 0) {
                    graphLayer.setHeightRatio(this.m_mainLayerHeightRatio);
                    if (i == 0) {
                        graphLayer.getRuler().setVisible(true);
                    } else {
                        graphLayer.getRuler().setVisible(false);
                    }
                } else {
                    int subLayerHeight = (100 - this.m_mainLayerHeightRatio) / this.m_paintGraphLayerList.getMaxLayerNo();
                    graphLayer.setHeightRatio(subLayerHeight);
                    graphLayer.getRuler().setVisible(true);
                }
                ++i;
            }
        } else {
            i = 0;
            while (i < this.m_paintGraphLayerList.getValues().size()) {
                graphLayer = this.m_paintGraphLayerList.getValues().get(i);
                graphLayer.setHeightRatio(100);
                if (i == 0) {
                    graphLayer.getRuler().setVisible(true);
                } else {
                    graphLayer.getRuler().setVisible(false);
                }
                ++i;
            }
        }
        i = 0;
        while (i < this.m_paintGraphLayerList.getValues().size()) {
            graphLayer = this.m_paintGraphLayerList.getValues().get(i);
            if (graphLayer.getLayerNo() == 0) {
                graphLayer.setSyncRuler(true);
            } else {
                graphLayer.setSyncRuler(false);
            }
            ++i;
        }
        this.m_paintGraphLayerList.syncRuler();
        this.setShowSubLayerRect(false);
    }

    public CoreFramework getSignalBox() {
        return this.m_signalBox;
    }

    public void setSignalBox(CoreFramework p_signalBox) {
        this.m_signalBox = p_signalBox;
        this.clearLayer();
    }

    public GraphLayer addLayer(String p_name, int p_layerNo, int p_divCount) throws GraphException {
        return this.m_graphLayerList.add(p_name, this.m_signalBox.getViewList().get(p_name), p_layerNo, p_divCount, this.m_titleBarTopOffset, this.m_indexBottomOffset);
    }

    public GraphLayer getLayer(String p_name) {
        for (GraphLayer layer : this.m_graphLayerList.getValues()) {
            if (!layer.getName().equals(p_name)) continue;
            return layer;
        }
        return null;
    }

    public void clearLayer() {
        this.m_graphLayerList = new GraphLayerList(this);
        this.m_paintGraphLayerList = new GraphLayerList(this);
    }

    public int getDropLayerNo(Point p_dropPoint) {
        if (this.m_paintGraphLayerList.getValues().size() <= 0) {
            return 0;
        }
        int mainLayerBorder = this.getHeight() * this.m_mainLayerHeightRatio / 100;
        if (p_dropPoint.y <= mainLayerBorder) {
            return 0;
        }
        return this.m_paintGraphLayerList.getMaxLayerNo() + 1;
    }

    protected GraphLayerList getPaintGraphLayerList() {
        return this.m_paintGraphLayerList;
    }

    public boolean isEmpty() {
        return this.m_empty;
    }

    public String getEmptyMessage() {
        return this.m_emptyMessage;
    }

    public void setEmptyMessage(String p_emptyMessage) {
        this.m_emptyMessage = p_emptyMessage;
    }

    public Color getEmptyMessageForeColor() {
        return this.m_emptyMessageForeColor;
    }

    public void setEmptyMessageForeColor(Color p_emptyMessageForeColor) {
        this.m_emptyMessageForeColor = p_emptyMessageForeColor;
    }

    public Font getEmptyMessageFont() {
        return this.m_emptyMessageFont;
    }

    public void setEmptyMessageFont(Font p_emptyMessageFont) {
        this.m_emptyMessageFont = p_emptyMessageFont;
    }
}

