/*
 * Decompiled with CFR 0.152.
 */
package jp.robotbrain.tools;

import java.util.ArrayList;
import jp.robotbrain.html.HtmlFormException;
import jp.robotbrain.html.HtmlHref;
import jp.robotbrain.html.HtmlParser;
import jp.robotbrain.html.UtilHtml;
import jp.robotbrain.net.CookieException;
import jp.robotbrain.net.HttpRecvException;
import jp.robotbrain.net.HttpSendException;
import jp.robotbrain.net.Web;

public class WebLs {
    public static void main(String[] args) {
        if (args.length <= 0) {
            throw new RuntimeException("args length error");
        }
        String url = args[0];
        String charset = Web.getCharSet(url);
        if (charset == null) {
            charset = "UTF-8";
        }
        Web web = new Web(charset);
        try {
            String html = web.go(url);
            ArrayList<HtmlHref> hrefList = HtmlParser.parseHtmlHref(html);
            for (HtmlHref href : hrefList) {
                String fullUrl = UtilHtml.moveURL(url, href.getURL());
                System.out.println(fullUrl);
            }
        }
        catch (HttpSendException e) {
            throw new RuntimeException("http send error");
        }
        catch (HttpRecvException e) {
            throw new RuntimeException("http recv error");
        }
        catch (CookieException e) {
            throw new RuntimeException("http cookie error");
        }
        catch (HtmlFormException e) {
            throw new RuntimeException("move url error");
        }
    }
}

